function [iR,iR2,dpsi,dpsi2,dpsi2oR2,dpsidV,F,epsilon,Rgeom,kappa,delta,Phib,tgridin,rhodatain,config, params] = get_equilibrium_data(config, params)
% function [iR,iR2,dpsi,dpsi2,dpsi2oR2,dpsidV,F,epsilon,Rgeom,kappa,delta,Phib,tgridin,rhodatain,config, params] = get_equilibrium_data(config, params)
% iR,iR2,dpsi,dpsi2,dpsi2oR2,dpsidV,F,epsilon,Rgeom,kappa,delta -> dependence (rhotor_uniform_fixed_on_time, time)
% Phib,tgridin -> dependence (time)
% rhodatain -> 1D array containing uniform rhotor grid fixed in times on
% which the other data are interpolated at

% Get variables from file with equilibrium data
switch config.equi.source
    case {'chease','mock'}
        
        % (Number of filename = number of config.equi.times) or just one
        % file for all equilibria
        assert( ~(numel(config.equi.times)>1 && ( numel(config.equi.filenames) ~= numel(config.equi.times))) , ...
            'RAPTOR:Mismatch_neqfile_neqtimes',...
            'Number of files(=%d) does not match number of eqtimes(=%d)',...
            numel(config.equi.filenames),numel(config.equi.times));
        
        % CHEASE
        [iR,iR2,dpsi,dpsi2,dpsi2oR2,dpsidV,F,epsilon,Rgeom,kappa,delta,Phib,tgridin,rhodatain,config] = CHEASE2SI(config);
        
        if (config.realtime) && (~strcmp(config.equi.tokamak,'ITER'))
            % if running in real-time, we will get these profiles from another equilibrium
            % code, not necessarily on this rhoin grid.
            % map to another grid in this case, so we have the right LamG matrices too.
            rhoin = [0,0.25:0.1:0.9,0.95,1]'; % relatively small grid for now, exclude axis for accuracy
            iR = interp1(rhodatain,iR,rhoin','spline')';
            iR2 = interp1(rhodatain,iR2,rhoin','spline')';
            dpsi = interp1(rhodatain,dpsi,rhoin','spline')';
            dpsi2 = interp1(rhodatain,dpsi2,rhoin','spline')';
            dpsi2oR2 = interp1(rhodatain,dpsi2oR2,rhoin','spline')';
            dpsidV = interp1(rhodatain,dpsidV,rhoin,'spline');
            F = interp1(rhodatain,F,rhoin,'spline');
            epsilon = interp1(rhodatain,epsilon,rhoin,'spline');
            kappa = interp1(rhodatain,kappa,rhoin,'spline');
            Rgeom = interp1(rhodatain,Rgeom,rhoin,'spline');
            delta = interp1(rhodatain,delta,rhoin,'spline');
            rhodatain = rhoin;
        end
    case 'astra'
        % ASTRA
        [iR,iR2,dpsi,dpsi2,dpsi2oR2,dpsidV,F,epsilon,Rgeom,kappa,delta,Phib,tgridin,rhodatain] = ASTRA_to_RAPTOR(config);
    case 'IMAS'
        [iR,iR2,dpsi,dpsi2,dpsi2oR2,dpsidV,F,epsilon,Rgeom,kappa,delta,Phib,tgridin,rhodatain] = IMASequil2SI(config);
    case 'liuqe'
        switch config.equi.input_type
            case 'external:node'
                error('To be implemented')
            case 'external:file'
                error('No longer mantained')
                [iR,iR2,dpsi,dpsi2,dpsi2oR2,dpsidV,F,epsilon,Rgeom,kappa,delta,Phib,tgridin,rhodatain] = LIUQEfile2RAPTOR(config);
            case 'external:rerun_standard_liuqe'
                error('To be implemented')
            otherwise
                error(['config.equi.input_type ' config.equi.input_type 'not consistent with config.equi.source = liuqe']);
        end
  case 'mock'    
    otherwise
        error('no other case implemented yet');
end
return
