function varargout = runaways(varargin) %#codegen

%% DEFAULT PARAMETERS
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Input processing

if nargin == 0,
    varargout{1} = runaways('none'); % load default params
    return %empty call, probably to get default structures
elseif nargin == 1
    % get default parameters for each case
    def_params.modeltype = varargin{1}; 
    switch def_params.modeltype
        case 'runaways_analytic'
            def_params.params = runaways_analytic;
        case 'LUKE'
            def_params.params = runaways_LUKE; % this is exactly the same module
        case 'none'
            def_params.params.active = false;
        otherwise
            error('invalid runaways model type ''%s''',def_params.modeltype)
    end
    varargout{1} = def_params; % return appropriate parameter structure
    return
elseif nargin==6;
    stap = varargin{1};
    geop = varargin{2};
    u = varargin{3};
    it = varargin{4};
    model  = varargin{5};
    runaways_params = varargin{6}; % distribute inputs
else
    error('must call with 0 or 6 inputs');
end

%% Compute output
if runaways_params.active
    switch model.runaways
        case 'runaways_analytic'
            [jreB] = runaways_analytic(stap,geop,u,it,model,runaways_params);
        case 'runaways_LUKE'
            [jreB] = runaways_LUKE(stap,geop,u,it,model,runaways_params);
        otherwise
            error('invalid setting for runaways model');
    end
else
    jreB  = zeros(model.rgrid.nrhogauss,1);
end

varargout{1} = jreB;
return