function varargout = ichcd(varargin) %#codegen

%% DEFAULT PARAMETERS
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Input processing

if nargin == 0
    varargout{1} = RAPTORmodule('none'); % load default params
    return %empty call, probably to get default structures
elseif nargin == 1
  error('this use is deprecated, use RAPTORmodule() instead');
    % get default parameters for each case
    def_params.modeltype = varargin{1}; 
    switch def_params.modeltype
        case 'ichcd_gaussian'
            def_params.params = ichcd_gaussian;
        case 'ichcd_manual'
            def_params.params = ichcd_manual; % this is exactly the same module
        case 'ichcd_colli'
            def_params.params = ichcd_colli; % Collision model
        case 'none'
            def_params.params.active = false;
        otherwise
            error('invalid ichcd model type ''%s''',def_params.modeltype)
    end
    varargout{1} = def_params; % return appropriate parameter structure
    return
elseif nargin==6
    stap = varargin{1};
    geop = varargin{2};
    u = varargin{3};
    it = varargin{4};
    model  = varargin{5};
    ichcd_params = varargin{6}; % distribute inputs
else
    error('must call with 0 or 6 inputs');
end

%% Compute output
if ichcd_params.active
  switch model.ichcd.name
    case 'hcd_gaussian'
      [Pice,Pici,jic,pfast,...
        dPice_dx,dPici_dx,djic_dx,dpfast_dx,...
        dPice_du,dPici_du,djic_du,dpfast_du] = hcd_gaussian(stap,geop,u,it,model,model.ichcd,ichcd_params);
    case 'hcd_manual'
      [Pice,Pici,jic,pfast,...
        dPice_dx,dPici_dx,djic_dx,dpfast_dx,...
        dPice_du,dPici_du,djic_du,dpfast_du] = hcd_manual(stap,geop,u,it,model,model.ichcd,ichcd_params);
    case 'hcd_external'
      [Pice,Pici,jic,pfast,...
        dPice_dx,dPici_dx,djic_dx,dpfast_dx,...
        dPice_du,dPici_du,djic_du,dpfast_du] = hcd_external(stap,geop,u,it,model,model.ichcd,ichcd_params);
    case 'ichcd_colli'
      [Pice,Pici,jic,dPice_dx,dPici_dx,djic_dx,dPice_du,dPici_du,djic_du] = ichcd_colli(stap,geop,u,it,model,ichcd_params);
      pfast = zeros(model.rgrid.nrhogauss,1); % place holder for pfast (later)
      dpfast_du = zeros(model.rgrid.nrhogauss,model.dims.nu);
    otherwise
      error('invalid setting for ichcd model');
  end

else
    Pice = zeros(model.rgrid.nrhogauss,1);
    Pici = zeros(model.rgrid.nrhogauss,1);
    jic  = zeros(model.rgrid.nrhogauss,1);
    pfast = zeros(model.rgrid.nrhogauss,1);
    dPice_dx = zeros(model.rgrid.nrhogauss,model.dims.nx);
    dPici_dx = zeros(model.rgrid.nrhogauss,model.dims.nx);
    djic_dx  = zeros(model.rgrid.nrhogauss,model.dims.nx);
    dpfast_dx = zeros(model.rgrid.nrhogauss,model.dims.nx);
    dPice_du = zeros(model.rgrid.nrhogauss,model.dims.nu);
    dPici_du = zeros(model.rgrid.nrhogauss,model.dims.nu);
    djic_du  = zeros(model.rgrid.nrhogauss,model.dims.nu);
    dpfast_du = zeros(model.rgrid.nrhogauss,model.dims.nu);
end

varargout{1} = Pice;
varargout{2} = Pici;
varargout{3} = jic;
varargout{4} = pfast;
varargout{5} = dPice_dx;
varargout{6} = dPici_dx;
varargout{7} = djic_dx;
varargout{8} = dpfast_dx;
varargout{9} = dPice_du;
varargout{10} = dPici_du;
varargout{11} = djic_du;
varargout{12} = dpfast_du;

return