function tauE_H98 = eval_tauEH98(x,g,v,model,~,varargin) 
% Energy confinement time scaling law for H-mode: IPB 1999, H98(y,2)

if nargin==0
    error('Power loss has to be an input');
else
    Ploss = varargin{1};
end

% Elongation
kappa = eval_kappa(x,g,v,model,false);
% Aspect ratio
epsilon = eval_epsilon(x,g,v,model,false);
% Magnetic field
B0 = model.equi.B0; % eval_B0(x,g,v,model,false);
% Plasma current
Ip = eval_Ipl(x,g,v,model,false);
% Electron density
ne = eval_ne(x,g,v,model,false);
ne19 = ne(1)/1e19;
% tau_scaling: 
tauE_H98 = (5.62e-2*(Ip(end)/1e6).^0.93.*B0^0.15.*ne19^0.41).*(Ploss/1e6).^-0.69.*...
    model.equi.R0^1.97.*epsilon(end).^0.58.*kappa(end).^0.78.*model.atom.Ai.^0.19;

return