function [press,dpress_dx] = eval_press(x,g,v,model,gauss)
% function [press,dpress_dx] = eval_press(x,g,v,model,whichgrid)
% #codegen

if nargout==1
    Te = eval_te(x,g,v,model,gauss);
    Ti = eval_ti(x,g,v,model,gauss);
    ne = eval_ne(x,g,v,model,gauss);
    ni = eval_ni(x,g,v,model,gauss);
    n1 = eval_nx(1,x,g,v,model,gauss,false);
    n2 = eval_nx(2,x,g,v,model,gauss,false);
    n3 = eval_nx(3,x,g,v,model,gauss,false);
    
    niall = ni+n1+n2+n3;
    press = 1.602e-19*(Te.*ne + Ti.*niall);
    
else
    
    [Te,dTe_dx] = eval_te(x,g,v,model,gauss);
    [Ti,dTi_dx] = eval_ti(x,g,v,model,gauss);
    [ne,dne_dx] = eval_ne(x,g,v,model,gauss);
    [ni,dni_dx] = eval_ni(x,g,v,model,gauss);
    [n1,dn1_dx] = eval_nx(1,x,g,v,model,gauss,false);
    [n2,dn2_dx] = eval_nx(2,x,g,v,model,gauss,false);
    [n3,dn3_dx] = eval_nx(3,x,g,v,model,gauss,false);
    
    niall = ni+n1+n2+n3;
    dniall_dx = dni_dx + dn1_dx + dn2_dx + dn3_dx;
    
    press = 1.602e-19*(Te.*ne + Ti.*niall);
    dpress_dx = 1.602e-19*(...
        bsxfun(@times,ne,dTe_dx) + bsxfun(@times,niall,dTi_dx) + ...
        bsxfun(@times,Te,dne_dx) + bsxfun(@times,Ti,dniall_dx));
end


return
