function [li3,dli3_dx] = eval_li3(x,g,v,model)
% function [li3,dli3_dx] = eval_li3(x,g,v,model)
% #codegen

if nargout>1
    der = true; % compute derivative
    dli3_dx = zeros(1,numel(x)); % init
else
    der = false;
end

[Ip,dIp_dx] = eval_Ipl(x,g,v,model,false);
[Wpol,dWpol_dx] = eval_Wpol(x,g,v,model,false);

li3 = [1e7/(pi*model.equi.R0)*Wpol(2)./(Ip(2).^2);...
    1e7/(pi*model.equi.R0)*Wpol(2:end)./(Ip(2:end).^2)];

if der
    dli3_dx = bsxfun(@times,1e7/(pi*model.equi.R0)./(Ip.^2),dWpol_dx) + ...
        -2*bsxfun(@times,li3./Ip,dIp_dx);
    dli3_dx(1,:) = dli3_dx(2,:);
end

return
