function [LY] = liut_bf(L, LXk, pprime, ttprime)
% call liuqe with prescribed basis functions 
bfp = prepare_LIUQE_bf(sign(LXk.Ip),pprime,ttprime);

% Running LIUQE with prescribed basis functions
LY = liut( L, LXk, 'bfct', @bf3imex, 'bfp', bfp, 'pq', L.pq );

return

function bfp = prepare_LIUQE_bf(sIp,pprime,ttprime)
assert(iscolumn(pprime) && iscolumn(ttprime),'pprime and ttprime must be column vectors');

% Change the sign based on the Ip
sign_multiplier = -sign(sIp);

% Check if I really have to multiply also the pprime or just the ttprime by
% the sign
basis_functions = struct();
basis_functions.gN1 = sign_multiplier*pprime;
basis_functions.gN2 = sign_multiplier*ttprime;
basis_functions.gN3 = 0*pprime;


% Compute the integral of the basis functions
basis_functions.IgN1 = zeros(size(basis_functions.gN1));
basis_functions.IgN2 = zeros(size(basis_functions.gN2));
basis_functions.IgN3 = zeros(size(basis_functions.gN3));

[ basis_functions.IgN1, basis_functions.IgN2,...
    basis_functions.IgN3] = bfprmex(basis_functions.gN1...
    ,basis_functions.gN2,basis_functions.gN3);


% Basis functions into bfp structure
bfp = struct('gNg',...
    [basis_functions.gN1,...
    basis_functions.gN2,...
    basis_functions.gN3],...
    'IgNg', ...
    [basis_functions.IgN1,...
    basis_functions.IgN2,...
    basis_functions.IgN3],...
    'fPg',[1;0;0],...
    'fTg',[0;1;0]);

return