function [dVpdkappa,dVppdkappa,dPhibdkappa,dg23ordkappa,dg1dkappa] = get_dgeom_dkappa(x,g,v,model)
% Get derivatives of the geometrical parameters over the plasma boundary
% elongation.

Vp = eval_Vp(x,g,v,model,true);
Vpp = eval_Vpp(x,g,v,model,true);
g23or = eval_g23or(x,g,v,model,true);
g1 = eval_g1(x,g,v,model,true);
Phib = eval_Phib(x,g,v,model,true);
kappa = eval_kappa(x,g,v,model,true);

% Vp ~ kappa^1.0
dVpdkappa = Vp./kappa;
% Vpp ~ kappa^1.1
dVppdkappa = Vpp./kappa;
% Phib ~ kappa^1.0
dPhibdkappa = Phib/kappa;
% g23or~ kappa^1.25
dg23ordkappa = g23or./kappa;
% g1 ~ kappa^1.28
dg1dkappa = g1./kappa;

return



