function out = LY2RAPTORout(L,LY)
% LIUQE outputs to RAPTOR out definition (for GUI);
out.time = LY.t';

psiN = L.pQ.^2;
[rhotor,iR,iR2,dpsi2,dpsi2oR2,dpsidV,F,Phib] = LY2geom(psiN,LY);

psia = LY.FA'; psib = LY.FB'; % axis and boundary psi
psi = bsxfun(@plus,psiN*(psib-psia),psia);
if psib<psia
    psi=-out.psi; % flip sign if necessary
end
rhotorN = linspace(0,1,21)';

out.Ip = abs(LY.Ip');
out.Phib = abs(Phib);

for it = 1:numel(out.time)
    out.iota(:,it) = interp1(rhotor(:,it),abs(LY.iqQ(:,it))',rhotorN);
    out.p(:,it)    = interp1(rhotor(:,it)',LY.PQ(:,it),rhotorN);
    out.F(:,it)    = interp1(rhotor(:,it)',abs(LY.TQ(:,it)),rhotorN);
end
out.q    = 1./out.iota;
  
out.rho = rhotorN;
return
