function out=CRONOSdata2RAPTORout(rho,time,data,param)
% out = CRONOSdata2RAPTORout(rho,time,data,param);
% leave 'rho' or 'time' empty to leave data on original grids

% table of correspondence between RAPTOR out terms and CRONOS data
% structure

map = {{'q'   ,     'data.prof.q'},...
    {'iota',     '1./data.prof.q'},...
    {'shear'   , 'data.prof.shear'},...
    {'q0'   ,    'data.equi.q0'},...
    {'qmin'   ,  'data.gene.qmin'},...
    {'psi' ,     '-2*pi*data.prof.psi'},...
    {'Upl' ,     '-2*pi*data.prof.dpsidt'},...
    {'te' ,      'data.prof.te'},...
    {'ti' ,      'data.prof.ti'},...
    {'ne' ,      'data.prof.ne'},...
    {'ni' ,      'data.prof.ni'},...
    {'p'  ,      'data.prof.ptot'},...
    {'ze' ,      'data.prof.zeff'},...
    {'vt' ,      'data.prof.vtor_exp'},...
    {'Ip' ,      'data.equi.ip'},...
    {'li3' ,     'data.equi.li'},...
    {'betaN' ,   'data.equi.betan'},...
    {'beta' ,    '100*data.gene.beta'},...
    {'jbs',      'data.neo.jboot'},...
    {'signeo',   '1./(data.neo.eta)'},...
    {'chie',     '(data.coef.ee./data.prof.ne)'},...
    {'chii',     '(data.coef.ii./data.prof.ni)'},...
    {'Pbrem',    'data.gene.pbrem'},...
    {'Prad' ,    'data.gene.prad'},...
    {'Pei' ,     'data.gene.qei'},...
    {'Poh'  ,    'data.gene.paddohm'},...
    {'Pnb'  ,    'data.gene.paddidn'},...
    {'Pec'  ,    'data.gene.paddfce'},...
    {'Paux' ,    'data.gene.paddidn+data.gene.paddfce'},...
    {'Palphatot','data.gene.paddfus'},...
    {'Ploss',    'data.gene.ploss'},...
    {'pbrem',    'data.source.brem'},...
    {'prad',     'data.source.prad'},...
    {'pei',      'data.source.qei'},...
    {'poh',      'data.source.ohm'},...
    {'pnbe',     'data.source.idn.el'},...
    {'pnbi',     'data.source.idn.ion'},...
    {'jnb',      'data.source.idn.j'},...
    {'pec',      'data.source.fce.el'},...
    {'jec',      'data.source.fce.j'},...
    {'paux',     'data.source.totale.el'},...
    {'jni',      'data.source.totale.j'},...
    {'jaux',     'data.source.totale.j-data.source.jboot'},...
    {'joh',      'data.prof.jmoy-data.source.totale.j'},...
    {'jpar',     'data.prof.jmoy'},...
    {'palphae',  'data.source.fus.el'},...
    {'palphai',  'data.source.fus.ion'},...
    {'palphatot','data.source.fus.el+data.source.fus.ion'},...
    {'jbs',      'data.source.jboot'},...
    {'sne' ,     'data.source.idn.ne'},...
    {'Ioh',      'data.gene.ipohm'},...
    {'Ibs',      'data.gene.iboot'},...
    {'Iaux',     'data.gene.icd'},...
    {'Ini',      'data.gene.ini'},...
    {'Iec',      'data.gene.ifce'},...
    {'Inb',      'data.gene.iidn'},...
    {'fbs',      'data.gene.iboot./data.gene.ip'},...
    {'foh',      'data.gene.ipohm./data.gene.ip'},...
    {'fni',      'data.gene.ini./data.gene.ip'},...
    {'tauE',     'data.gene.taue'},...
    {'We'  ,     'data.gene.we'},...
    {'Wi'  ,     'data.gene.wion'},...
    {'Wth' ,     'data.gene.wth'},...
    {'Wpol',     'data.gene.wbp'},...
    {'g1'  ,     'data.equi.grho2.*data.equi.vpr.^2'},... <|gradV|^2>
    {'g2'  ,     'data.equi.grho2r2.*data.equi.vpr.^2'},... <|gradV|^2/R^2>
    {'g3'  ,     'data.equi.r2i'},... <1/R^2>
    {'Vp'  ,     'bsxfun(@times,data.equi.rhomax,data.equi.vpr)'},...
    };

%% grids - use input grids or keep old ones
t_cronos   = data.gene.temps;
r_cronos = param.gene.x;

if isempty(rho)
    interprho = false;
    out.rho = r_cronos;
else
    interprho = true;
    out.rho = rho;
end

if isempty(time)
    interptime = false;
    out.time = t_cronos';
else
    interptime = true;
    out.time = time;
end

out.it = 1:numel(out.time);
out.ntime = numel(out.time);
out.rho = rho;
out.nrho = numel(out.rho);

% first eval all strings to get good data
data = evalstrings(data);

%% interpolate and map to RAPTOR grid
for im=1:numel(map)
    mym = map{im};
    
    try
        cronosdata = full(eval(mym{2}));
        
        if length(cronosdata(:,1)) ~= length(t_cronos)
            cronosdata = 0.*t_cronos;
        end
        
        % interpolate to new t
        if interptime
            data_on_time = interp1(t_cronos,cronosdata,out.time,'linear',NaN)';
        else
            data_on_time = cronosdata';
        end
        
        
        % if profile data
        if size(cronosdata,2)==1 % only time
            out.(mym{1}) = data_on_time';
        else % profile data, interpolate on right rho
            if interprho
                out.(mym{1}) = interp1(r_cronos,data_on_time,out.rho);
            else
                out.(mym{1}) = data_on_time';
            end
        end
        
    catch err
        warning('could not interpolate %s to %s',mym{2}, mym{1});
        rethrow(err)
    end
end

function dataout=evalstrings(data)

dataout = data;

fields = fieldnames(data);
for ifield = 1:numel(fields)
    myfieldname = fields{ifield};
    myfield = data.(myfieldname);
    if ischar(myfield)
        dataout.(myfieldname) = eval(myfield);
    elseif isa(myfield,'struct')
        dataout.(myfieldname) = evalstrings(myfield);
    end
end
return
