function [yk,dh_dx,dh_du,Rk,sn] = diag_TCV_Ip(xk,gk,vk,~,RAPTORmodel)
%#codegen

%% Ip %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% diagnostic parameters
scal = 1; % typical scale
sn   = 1e3; % noise standard deviation

% yk = uk(1);

Ipl = eval_Ipl(xk,gk,vk,RAPTORmodel,false);
Ip = Ipl(end);
yk = Ip;

% scaling matrix
T = 1/scal*eye(numel(yk));
%iT = scal*eye(numel(yk));

% h (scaled output value)
hk = T*yk; % scaled measured output

% dh_dx
dh_dx = zeros(numel(hk),numel(xk));

% dh_du
dh_du = zeros(numel(hk),RAPTORmodel.dims.nu);
dh_du(:,1) = T;

% noise covariance
Rk = sn.^2*T*eye(numel(hk))*T';
return