%% RAPTOR Sawtooth Tutorial
% RAPTOR includes a sawtooth module. This tutorial explains how to use it
%%

close all hidden;
run('../RAPTOR_path.m');
[config] = RAPTOR_config; % load default params

% set some things
config.init.te0 = 100;
config.debug.iterdisp = 50;
config.grid.tgrid = [0.:0.0005:0.2]; % small time step to see crashes well

% load sawtooth model
config.saw = saw('porcelli'); % this is a dummy sawtooth model that just reduces Te
% set critical temperature
config.saw.params.s1crit = 0.4; % critical shear for reconnection

% generate model structure for these params.
[model,params,init,g,v,U] = build_RAPTOR_model(config);

% define input
rampfun = @(t,tmin,ymin,tmax,ymax) ...
    max(ymin,min((ymax-ymin)/(tmax-tmin)*(t-tmin),ymax-ymin)+ymin); % anonymous function for ramps
init.Ip0 = 80e3;
U(1,:) = rampfun(config.grid.tgrid,0,init.Ip0,0.05,200e3);

% Define the initial condition
x0 = RAPTOR_initial_conditions(model,init,g(:,1),v(:,1)); 

% run RAPTOR
simres = RAPTOR_predictive(x0,g,v,U,model,params);
out = RAPTOR_out(simres,model,params);
% inspect result
figure;
plot(out.time,out.te);