function exfbte(dissi,use_files)
% Obtain different FBT equilibria varying the power dissipation weight in 
% the parameter L.P.dissi.
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.
  figure;clf;
  names = cell(1,numel(dissi));
  if use_files
    prefix = 'tcv_102734_fbt';
    fileargs = {'pfile',[prefix,'_P'],'gfile',[prefix,'_G'],'xfile',[prefix,'_X']};
    [L0,LX0] = fbt('file',102734,[],fileargs{:});
  else
    [L0,LX0] = fbt('tcv' ,102734,[]);
  end
  Ia = NaN(L0.G.na,numel(dissi));
  for k = 1:numel(dissi)
    names{k} = ['dissi = ' num2str(dissi(k))]; % collect for bar plot
    subplot(2,numel(dissi),k);
    LX = LX0; LX.gpid = LX0.gpid/sqrt(dissi(k)/L0.P.dissi);
    LY = fbtt(L0,LX); % run FBTE
    Ia(:,k) = LY.Ia;
    meqplott(L0,LY); hold on;
    title(names{k});
    plot(L0.G.rv, L0.G.zv, 'k-'); % plot vessel position
    plot(L0.P.rlia1, L0.P.zlia1, 'bo'); % plot requested points imposed in LSQ cost function
    plot(L0.P.rlim1, L0.P.zlim1, 'ro'); % plot requested points imposed as fixed constraint
    axis equal
  end
  subplot(212)
  bar([Ia]); title('PFC currents') % plot of the coil currents
  set(gca,'xtick',1:16,'xticklabel',[num2str((1:8)','E%d');num2str((1:8)','F%d')],...
    'xgrid','on');
  ylabel('I_a [A]');
  legend(names)
end
