%% Exercise - Control and operation of tokamaks 2023
% Topic: Free boundary evolution, FBT & LIUQUE reconstruction
% 
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.
%%
% If access to TCV data using MDSplus is impossible use MAT-files by setting use_files = true
use_files = false;
% Provide path to MEQ toolbox
if use_files
    addpath(genpath('path_to_meq_directory'));
end
%% Exercise 1 - Design of the vacuum equilibrium field

% Input equilibrium parameters
Ip = -400e3;     % [A] total plasma current
kappa = 1.6;    % Elongation
betap = 0.3;    % Poloidal beta
li = 1;         % internal inductance
a = 0.25;       % [m] Plasma minor radius
r0 = 0.87;      % [m] R position of plasma axis
z0 = 0;         % [m] Z position of the plasma axis
%% 
% Required parameters

n = -1.44;      % field index
Br0 = 0;        % Br component on axis
%% 
% Compute required contraints

Bz0 = -mu0*Ip/4/pi/r0*(log(8*r0/a/sqrt(kappa)) + betap + li/2 - 3/2); % Bz component on axis
dBz0dr = -n * Bz0 / r0; % Derivative of Bz componet on axis
%% 
% Green's function's from function exgf
if use_files
  prefix = 'tcv_102735_fbt';
  fileargs = {'pfile',[prefix,'_P'],'gfile',[prefix,'_G'],'xfile',[prefix,'_X']};
  [L,~,LY] = fbt('file',102735,[],fileargs{:});
else
  [L,~,LY] = fbt('tcv',102735);
end

[Mxa,Brxa,Bzxa,~,Brpa,Bzpa,Cpa,na] = exgf(L.G,r0, z0);
rx = L.G.rx; zx = L.G.zx;
nr = numel(rx); nz = numel(zx);

%% 1.a Solve LSQ problem


%% 1.b Solve LSQ with fixed contraints


%% c. Solve using FBT and compare the different methods


%% 1.d Compare flux contributions


%% Exercise 2 - FBTE
% Effect of power dissipation weight on the coil currents obtained from FBTE. 

dissi = [1e-15];
exfbte(dissi,use_files);

%% Exercise 3 - LIUQE Reconstruction
% Study of the effect of the basis functions naas and nbbs to parametrize p' 
% and TT' in the Grad-Shafranov equation. 

shot = 40000;
time = 0.3;
exliuqe(shot, time, use_files);

