pro set_gains,gains

; $$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$ TCVCS RECIPE ROUTINE

; This routine is part of the TCVCS Recipe concept.
; AS such, it must be guaranteed to have been tested.
; ALL modifications to this routine must be checked off
; on a new listing of the module.

;+ TCVCS FILE : SET_GAINS.pro

; PURPOSE :
; Set the 24 loadable gains, according to the user-recipe gains

; ARGUMENTS :
; gains		gains, with the same number of elements as outputs

; RESTRICTIONS :

; UPDATED/REASONS :
; 	Jo Lister	Aug 1993	Original
;-
; Controlled by :       Jo
;                       Michael
; $$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$

print,'SET GAINS '+!stime

mds$put,'\pcs::feed_gains','$',gains

outputs = 	strupcase(mds$value('\pcs::phys_mat_a_outputs'))
outputs = strmid(outputs,2,3)

load_gains = intarr(24)+1
load_gains(fix(outputs)-1) = gains

mds$put,'\pcs::load_feed_gains','$',load_gains

end
