
; modifs:  MJD 09/7/96  Add the Fast Coil Current (IPOL_G)
;          MJD 25/2/97  Add the Fast Coil Voltage (UDC, UPOL)

; these functions are rather clumsy, but they avoid TDI time-wasting

function amp_gain,name,magvalues,magnames,labels,dim_labels

label 	= labels(where(name eq dim_labels))

index	= where(magnames eq name)
if(index(0) gt -1) then begin
  setting = magvalues(index(0))
endif else begin
  !tcvcs_error = ' ERROR !!!! Was not found in magnames'
  print,name,!tcvcs_error
  return,-1e30
endelse

old_nnn	= mds$value('_amp_nnn')
nnn	= mds$value('_amp_nnn=iii(element(3,"/","'+label(0)+'"))')

if(old_nnn ne nnn) then $
  dum = mds$value('_amp_gainmat=execute("\\magnetics::amp:cd_"//_amp_nnn)')

dum	= mds$value('_n=execute(element(2,"/","'+label(0)+'"))')
gain 	= mds$value('_amp_gainmat[_n-1,'+string(setting)+']')

return, -0.9969*gain

end

function pre_gain,name,magvalues,magnames,labels,dim_labels

label = labels(where(name eq dim_labels))

index=where(magnames eq name)
if(index(0) gt -1) then begin
  setting = magvalues(index(0))
endif else begin
  !tcvcs_error=' ERROR !!!! Was not found in magnames'
  print,name,!tcvcs_error
  return,1e30
endelse

old_nnn	= mds$value('_pre_nnn')
nnn	= mds$value('_pre_nnn=iii(element(3,"/","'+label(0)+'"))')

if(old_nnn ne nnn) then $
  dum	= mds$value('_pre_gainmat=execute("\\magnetics::pre:cd_"//_pre_nnn)')

dum	= mds$value('_n=execute(element(2,"/","'+label(0)+'"))')
gain 	= mds$value('_pre_gainmat[_n-1,'+string(setting)+']')

return, gain

end

function int_gain,name,magvalues,magnames,labels,dim_labels

inds = where(name eq dim_labels)
if inds(0) eq -1 then begin
  !tcvcs_error="ERROR in INT_GAIN: name <"+name+"> not in array dim_labels:"
  print,!tcvcs_error
  print,dim_labels
  return,1e30
endif

label = labels(inds(0))

index=where(magnames eq name)
if(index(0) gt -1) then begin
  setting = ((11-magvalues(index(0))) mod 8)
endif else begin
  !tcvcs_error=' ERROR !!!! Was not found in magnames'
  print,name,!tcvcs_error
  return,1e30
endelse

old_nnn	= mds$value('_int_nnn')
nnn	= mds$value('_int_nnn=iii(element(3,"/","'+label(0)+'"))')

if(old_nnn ne nnn) then begin
 gainmat = mds$value('_int_gainmat=execute("\\magnetics::int:cd_"//_int_nnn)')
endif

n	= mds$value('_n=execute(element(2,"/","'+label(0)+'"))')
gain 	= mds$value('_int_gainmat[_n-1,'+string(setting)+']')

return, -0.9969*gain

end

function pcs_invgains,channels

; $$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$ TCVCS RECIPE ROUTINE

; This routine is part of the TCVCS Recipe concept.
; AS such, it must be guaranteed to have been tested.
; ALL modifications to this routine must be checked off
; on a new listing of the module.

;+ TCVCS FILE : PCS_INVGAINS.pro

; PURPOSE :
; gets the physical calibration of magnetics channels

; ARGUMENTS :
; channels		names of the channels needed

; RESTRICTIONS :

; UPDATED/REASONS :
;	Jo Lister	July 1993	Original
;	MJ Dutch	Mar  1995	Bphi inverted, use calibs magnetics.
;	Jo Lister	Jan 1998	Set up for variable polarity - cleanup
;-
; Controlled by :       Jo
; $$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$

print,'PCS_INVGAINS  '+!stime+' ',n_elements(channels)

; initialise the gainmat calls to -1
x=mds$value('_amp_nnn=-1;_pre_nnn=-1;_int_nnn=-1')

; go and get the real-time settings of the magnetics
magdb_iget,magvalues,magnames
print,'MAGDB_IGET    '+!stime+' ',n_elements(magvalues)

; get the different vsystem labels
labels = mds$value("_labels=\vsystem::magdb_l")
dim_labels = dim_of('_labels')

channels = strtrim(strupcase(channels),2)
names=strtrim(strmid(channels,3,50),2)
types = strmid(names,0,8)

; Here we gamble on there being many channels and we do some work once

; area and polarity of the BPOL coils - not gain-dependent
bpol_003	= '\magnetics::bpol_003:area'+ $
		 '*\magnetics::pol_prob_char:polarity["003",*]'
bpol_011	= '\magnetics::bpol_011:area'+ $
		 '*\magnetics::pol_prob_char:polarity["011",*]'
sens_bpol_003 = mds$value(bpol_003)
sens_bpol_011 = mds$value(bpol_011)

; the current conversion values
escale  = mds$value('\magnetics::ipol:calibration["E_001"]')
fscale  = mds$value('\magnetics::ipol:calibration["F_001"]')
gscale  = mds$value('\magnetics::ipol:calibration["G_001"]')
gUscale = mds$value('\magnetics::upol:calibration["G_001"]')
ohscale = mds$value('\magnetics::ipol:calibration["OH_001"]')
torscale= mds$value('\magnetics::iphi:calibration')           ;amp/volt

; initialise the results
invgains = fltarr(n_elements(names))

print,'PCS_INVGAINS begin loop '+!stime
for i=0,n_elements(names)-1 do begin

  invgain = 1.0
  type = types(i)
  name = names(i)

; $$$$$$$$$$$$$$$  GET THE PREAMP AND THE AMPLI/INTEG
; $$$$$$$$$$$$$$$  DO THE CONVERSION OF THE SONDES TO PHYSICAL

 case 1 of
  (type eq 'AMP:IPOL') : begin
    invgain = 1./amp_gain(name+'_AMPGAIN',magvalues,magnames,labels,dim_labels)
    case strmid(name,0,11) of
      'AMP:IPOL_E_': invgain = invgain * escale ; amp/volt
      'AMP:IPOL_F_': invgain = invgain * fscale ;amp/volt
      'AMP:IPOL_G_': invgain = invgain * gscale ;amp/volt
      'AMP:UPOL_G_': invgain = invgain * gUscale ;volt/volt
      'AMP:UDC_G_0': invgain = invgain * gUscale ;volt/volt
      'AMP:IPOL_OH': invgain = invgain * ohscale ;amp/volt
      'AMP:IPOL_DO': invgain = invgain * ohscale ;amp/volt
      else: begin
        help,name
        !tcvcs_error='Invalid IPOL inside PCS_INVGAINS'
        print,!tcvcs_error 
	return,'ERROR'
      end
    endcase
  end

  (type eq 'AMP:RVLO' or type eq 'AMP:VLOO') : $
    invgain = 1./amp_gain(name+'_AMPGAIN',magvalues,magnames,labels,dim_labels)

  (type eq 'INT:VLOO' or type eq 'INT:RVLO') : $
    invgain = int_gain(name+'_INTGAIN',magvalues,magnames,labels,dim_labels)
 
  (type eq 'INT:ROG_') : $
    invgain = 1./ $
        pre_gain('PRE:'+strmid(name,4,50)+'_PREGAIN', $
		magvalues,magnames,labels,dim_labels) * $
    	int_gain(name+'_INTGAIN',magvalues,magnames,labels,dim_labels)

  (type eq 'INT:BPOL') : begin
    short_name=strmid(name,12,42)
    invgain_003 = 1./ $
	pre_gain('PRE:BPOL_003'+short_name+'_PREGAIN', 	$
		magvalues,magnames,labels,dim_labels) * $
    	int_gain('INT:BPOL_003'+short_name+'_INTGAIN', 	$
		magvalues,magnames,labels,dim_labels)
    invgain_011 = 1./ $
	pre_gain('PRE:BPOL_011'+short_name+'_PREGAIN', 	$
		magvalues,magnames,labels,dim_labels) * $
    	int_gain('INT:BPOL_011'+short_name+'_INTGAIN', 	$
		magvalues,magnames,labels,dim_labels)
    strindex = strmid(name,13,3)
    index = fix(strindex)-1
    weight = (sens_bpol_003(index)/invgain_003 + $
		sens_bpol_011(index)/invgain_011)/2.
    invgain = invgain / weight
  end

  (type eq 'AMP:BPOL') : begin
    short_name=strmid(name,12,42)
    invgain_003 = 1./ $
	pre_gain('PRE:BPOL_003'+short_name+'_PREGAIN', 	$
		magvalues,magnames,labels,dim_labels) / $
    	amp_gain('AMP:BPOL_003'+short_name+'_AMPGAIN', 	$
		magvalues,magnames,labels,dim_labels)
    invgain_011 = 1./ $
	pre_gain('PRE:BPOL_011'+short_name+'_PREGAIN', 	$
		magvalues,magnames,labels,dim_labels) / $
    	amp_gain('AMP:BPOL_011'+short_name+'_AMPGAIN', 	$
		magvalues,magnames,labels,dim_labels)
    strindex = strmid(name,13,3)
    index = fix(strindex)-1
    weight = (sens_bpol_003(index)/invgain_003 + $
		sens_bpol_011(index)/invgain_011)/2.
    invgain = invgain / weight
  end

  (type eq 'AMP:IPHI'):	invgain = invgain * torscale ;amp/volt

  (channels(i) eq 'FIR_FRINGE') : begin 
	invgain = invgain  	$
		  * 1.075 	$	; Correct for the A-matrix filter (JBL)	
		  * 0.1 	$       ; Conversion factor from FIR (CN)
		  * 2.^( 8 - vcs_iget('diag2db::fir:fringe_gain') )
        print,'FIR_INVGAIN ',invgain
  end

  (channels(i) eq '1MM_FRINGE') : begin
	invgain = invgain  	$ ;Include 1MM in list of inputs (SC, 27/02/11)
		  * (-0.1) 	$ ;Conversion factor (is also in
				  ;\base::onemm:fringe_count:conversion)
		  * 2.^( 8 - vcs_iget('diag2db::twomm:fringe_gain') )
        print,'1MM_INVGAIN ',invgain
  end

  (channels(i) eq '2MM_FRINGE') : $ 
	invgain = 1.0	; Include 2MM in list of recognized inputs (MJD 3/95)

  else: if(strmid(channels(i),0,2) ne 'GO') then $
		print,'A-Input not found : ',channels(i),' ',name,' ',type
  endcase 

  invgains(i) = invgain

endfor

print,'PCS_INVGAINS DONE  '+!stime

return,invgains

end


