pro mat_arrange,in,out,inscale,outscale,inlist,outlist,phys_mat,mat,mat_id,outs,in_index,out_index

; $$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$ TCVCS RECIPE ROUTINE

; This routine is part of the TCVCS Recipe concept.
; AS such, it must be guaranteed to have been tested.
; ALL modifications to this routine must be checked off
; on a new listing of the module.

;+ TCVCS FILE : MAT_ARRANGE.pro

; PURPOSE :
; converts a physical matrix (physmat) with scales to a gain matrix (mat)

; ARGUMENTS :
; in		physmat inputs
; out		physmat ouputs
; inscale	input scales
; outscale	output scales
; inlist	list of matrix inputs (mat)
; outlist	list of matrix outputs (mat)
; phys_mat	physmat
; mat		mat
; outs		ordered list of outscales
; in_index	index of inputs for mapping between physical and real world
; out_index	index of outputs for mapping between physical and real world

; RESTRICTIONS :

; UPDATED/REASONS :
;	Jo Lister July 1992	Original
;-
; Controlled by :       Jo
;                       Michael
; $$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
 
pwint,'MAT_ARRANGE '+mat_id+' '+!stime

; check what has been asked
x = size(phys_mat)
ins = [n_elements(in),n_elements(inscale),x(2)]
outs = [n_elements(out),n_elements(outscale),x(1)]

if(stdev(ins) gt 1e-4) or (stdev(outs) gt 1.e-4) then begin
  pwint,'MAT ARRANGE - Bad Input data dimensions'
  help,in,out,inscale,outscale,inlist,outlist,phys_mat
  !tcvcs_error = 'Mat_arrange Bad Input data dimensions'
  return
endif

; render case-insensitive
in      = strtrim(strupcase(in),2)
out     = strtrim(strupcase(out),2)
inlist  = strtrim(strupcase(inlist),2)
outlist = strtrim(strupcase(outlist),2)
nin     = n_elements(in)
nout    = n_elements(out)

; get indicies and check consistency
in_index  = intarr(nin)
out_index = intarr(nout)

; find the indices
for i=0,nin-1 do begin
  in_index(i)=where(in(i) eq inlist)
  if(in_index(i) eq -1) then begin
    pwint,'MAT_ARRANGE FAILED at least for INPUT ',i,in(i)
    pwint,inlist
    !tcvcs_error='MAT_ARRANGE FAILED at least for INPUT '+iii(i)+' '+in(i)
    return
  endif
endfor

for i=0,nout-1 do begin
  out_index(i)=where(out(i) eq outlist)
  if(out_index(i) eq -1) then begin
    pwint,'MAT_ARRANGE FAILED OUTPUT ',i,out(i)
    pwint,outlist
    !tcvcs_error='MAT_ARRANGE FAILED OUTPUT '+iii(i)+' '+out(i)
    return
  endif
endfor

; create the output scales for this matrix
outs = fltarr(n_elements(outlist))+1.e8
outs(out_index) = outscale

; make the produced matrix

nmat = 1
if(x(0) eq 3) then nmat = x(3)
mat = fltarr(n_elements(outlist),n_elements(inlist),nmat)

calibrate = (1./outscale)#inscale

if (nmat gt 0) then begin 
  for i=0,nmat-1 do begin
    mat(out_index,in_index,i) = phys_mat(*,*,i)*calibrate
  endfor
endif else begin 
    mat(out_index,in_index) = phys_mat(*,*)*calibrate
endelse

end
