pro liuqe_params

; $$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$

; TCVCS RECIPE ROUTINE

; This routine is part of the TCVCS Recipe concept.
; As such, it must be guaranteed to have been tested.
; ALL modifications to this routine must be checked off
; on a new listing of the module.

; Updated/Reason:

; Controlled by :       SC

; $$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$

; *****************************************************

; Stefano Coda May 2000
;	Last modified 29/08/01

;	Sets up Liuqe parameters based on programmed (MGAMS) plasma shape
;

on_error,2

; make sure model is still open
mds$open,'tcv_shot',-1

print,'Setting Liuqe parameters'
nequil=mds$value('\pcs::mgams.data:numeq')
if nequil lt 1 then begin
  message, 'numeq < 1!'
  goto, def_params
endif
iansha=mds$value('\pcs::mgams.data:iansha')
rlia1=mds$value('\pcs::mgams.data:rlia1')
zlia1=mds$value('\pcs::mgams.data:zlia1')
ilia=mds$value('\pcs::mgams.data:ilia')
rlim1=mds$value('\pcs::mgams.data:rlim1')
zlim1=mds$value('\pcs::mgams.data:zlim1')
ilie=mds$value('\pcs::mgams.data:ilie')
rmajo1=mds$value('\pcs::mgams.data:rmajo1')
rmino1=mds$value('\pcs::mgams.data:rmino1')
zmajo1=mds$value('\pcs::mgams.data:zmajo1')
cappa1=mds$value('\pcs::mgams.data:cappa1')
rout=fltarr(nequil)
rin=fltarr(nequil)
zhigh=fltarr(nequil)
zlow=fltarr(nequil)
kappa=fltarr(nequil)
for i=0,nequil-1 do begin
    if iansha(i) eq 0 then begin
; drawn boundary
      if ilia(i) ne 0 then begin
        rbou=rlia1(0:ilia(i)-1,i)
        zbou=zlia1(0:ilia(i)-1,i)
        if ilie(i) ne 0 then begin
          rbou=[rbou,rlim1(0:ilie(i)-1,i)]
          zbou=[zbou,zlim1(0:ilie(i)-1,i)]
        endif
      endif else begin
	if ilie(i) eq 0 then begin
	  message, 'Equilibrium # '+arr2str(i+1)+': iansha=0, ilia=0, ilie=0!'
	  goto, def_params
	endif
        rbou=rlim1(0:ilie(i)-1,i)
        zbou=zlim1(0:ilie(i)-1,i)
      endelse
; attempt to eliminate points lying beyond X-points for diverted plasmas
      rbou=rbou(sort(zbou))
      zbou=zbou(sort(zbou))
slim_it:
      zave=total(zbou)/n_elements(zbou)
      rave=total(rbou)/n_elements(rbou)
      sqrad=(zbou-zave)^2+(rbou-rave)^2
      if total(sqrad)/n_elements(sqrad) gt 1.15*median(sqrad) then begin
        if abs(zbou(0)-zave) gt abs(zbou(n_elements(zbou)-1)-zave) then begin
          rbou=rbou(1:n_elements(rbou)-1)
          zbou=zbou(1:n_elements(zbou)-1)
        endif else begin
          rbou=rbou(0:n_elements(rbou)-2)
          zbou=zbou(0:n_elements(zbou)-2)
        endelse
        goto,slim_it
      endif
      rout(i)=max(rbou)
      rin(i)=min(rbou)
      zhigh(i)=max(zbou)
      zlow(i)=min(zbou)
      kappa(i)=(zhigh(i)-zlow(i))/(rout(i)-rin(i))
      meanrad=sqrt(total(sqrad)/n_elements(sqrad))
      rout(i)=rout(i)+0.02*sqrt(meanrad/kappa(i))
      rin(i)=rin(i)-0.02*sqrt(meanrad/kappa(i))
      zhigh(i)=zhigh(i)+0.02*sqrt(meanrad*kappa(i))
      zlow(i)=zlow(i)-0.02*sqrt(meanrad*kappa(i))
    endif else begin
; analytic boundary
      rout(i)=rmajo1(i)+rmino1(i)*1.02
      rin(i)=rmajo1(i)-rmino1(i)*1.02
      zhigh(i)=zmajo1(i)+rmino1(i)*cappa1(i)*1.02
      zlow(i)=zmajo1(i)-rmino1(i)*cappa1(i)*1.02
      kappa(i)=cappa1(i)
    endelse
endfor

nelem=max([3,min([12,2*round(2*max(kappa))]),3])
rop=max(rout)
rip=min(rin)
zup=max(zhigh)
zlp=min(zlow)

; Liuqe 1
mds$put,'\results::parameters:nelem',arr2str(nelem)
mds$put,'\results::parameters:rop',arr2str(rop)
mds$put,'\results::parameters:rip',arr2str(rip)
mds$put,'\results::parameters:zup',arr2str(zup)
mds$put,'\results::parameters:zlp',arr2str(zlp)
; Liuqe 2
mds$put,'\results::parameters_2:nelem',arr2str(nelem)
mds$put,'\results::parameters_2:rop',arr2str(rop)
mds$put,'\results::parameters_2:rip',arr2str(rip)
mds$put,'\results::parameters_2:zup',arr2str(zup)
mds$put,'\results::parameters_2:zlp',arr2str(zlp)
; Liuqe 3
mds$put,'\results::parameters_3:nelem',arr2str(nelem)
mds$put,'\results::parameters_3:rop',arr2str(rop)
mds$put,'\results::parameters_3:rip',arr2str(rip)
mds$put,'\results::parameters_3:zup',arr2str(zup)
mds$put,'\results::parameters_3:zlp',arr2str(zlp)

goto,done

def_params:
; on error, set standard Liuqe parameters

message, 'Parameter optimization has failed: setting standard Liuqe parameters'

mds$put,'\results::parameters:nelem','12'
mds$put,'\results::parameters:rop','1.12'
mds$put,'\results::parameters:rip','0.63'
mds$put,'\results::parameters:zup','0.73'
mds$put,'\results::parameters:zlp','-0.73'

mds$put,'\results::parameters_2:nelem','12'
mds$put,'\results::parameters_2:rop','1.12'
mds$put,'\results::parameters_2:rip','0.63'
mds$put,'\results::parameters_2:zup','0.73'
mds$put,'\results::parameters_2:zlp','-0.73'

mds$put,'\results::parameters_3:nelem','12'
mds$put,'\results::parameters_3:rop','1.12'
mds$put,'\results::parameters_3:rip','0.63'
mds$put,'\results::parameters_3:zup','0.73'
mds$put,'\results::parameters_3:zlp','-0.73'

done:

print,'nelem = ',nelem
print,'rop = ',rop
print,'rip = ',rip
print,'zup = ',zup
print,'zlp = ',zlp

print,'liuqe_params completed'
end
