pro alim_mode, modes, levels, selects, signbit

; $$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$ TCVCS RECIPE ROUTINE

; This routine is part of the TCVCS Recipe concept.
; AS such, it must be guaranteed to have been tested.
; ALL modifications to this routine must be checked off
; on a new listing of the module.

;+ TCVCS FILE : ALIM_MODE.pro

; PURPOSE :
; Sets up the JSI Mode, level and selection in the PCS tree
; Ditto for the FPS

; ARGUMENTS :
; modes		'A','B' or 'C'
; levels	'20','50','80','100'    (FPS level anywhere from '0' to '100')
; selects	'OFF' or 'ON'

; RESTRICTIONS :
; either one or 20 of each argument
; if one, then copied *20
; Alims are ORDERED, --> E1-8,F1-8,OH1-2,TOR,FPS

; UPDATED/REASONS :
;	 Jo Lister, Dec 1993 NEW
;	 M. Dutch,  Jan 1995 Add 20th element for FPS (Alim Rapide)
;	 SC, 26/09/05: added sign bit argument
;-
; Controlled by :       Jo
;                       Michael
; $$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$

print,'_-_- '+stime()+' ALIM_MODE: starting'

if (n_params() lt 3 or n_params() gt 4) then begin
  !tcvcs_error = 'ALIM_MODE bad args.'
  print,!tcvcs_error
  help
  print,'_-_- '+stime()+' ALIM_MODE: aborted with bad number of arguments'
  return
endif

n = n_elements(levels)*n_elements(modes)*n_elements(selects)
if(n ne 1 and n ne 20 and n ne 20*20 and n ne 20*20*20) then begin
  !tcvcs_error = 'ALIM_MODE bad args.'
  print,!tcvcs_error
  help
  print,'_-_- '+stime()+' ALIM_MODE: aborted with bad dimensions of arguments'
  return
endif

if(n_elements(levels)  eq 1) 	then  levels	= replicate(levels, 20)
if(n_elements(modes)   eq 1) 	then  modes	= replicate(modes,  20)
if(n_elements(selects) eq 1) 	then  selects	= replicate(selects,20)

; force the toroidal choice,independently of the user choice
levels(18) = '100'
 modes(18) = 'A'

; check the 3 alim requests for acceptability
bad_levels=where((levels(0:18) ne '20') and (levels(0:18) ne  '50') and $
	         (levels(0:18) ne '80') and (levels(0:18) ne '100'))
not_xfps = 1-execute('fpslevel='+levels(19))

bad_fps_level = (fpslevel lt 0) or (fpslevel gt 100) or not_xfps

if ((bad_levels(0) ne -1) or (bad_fps_level eq 1)) then begin
   print,'Invalid levels ',levels
   !tcvcs_error = 'ALIM modes : ERROR ON levels'
   print,'_-_- '+stime()+' ALIM_MODE: aborted'
   return
endif

modes = strupcase(modes)
bad_modes=where((modes ne 'A') and (modes ne 'B') and (modes ne 'C'))
if (bad_modes(0) ne -1) then begin
   print,'Invalid modes ',modes
   !tcvcs_error = 'ALIM modes : ERROR ON modes'
   print,'_-_- '+stime()+' ALIM_MODE: aborted'
   return
endif

bad_selects=where((selects ne 'ON') and (selects ne 'OFF'))
if (bad_selects(0) ne -1) then begin
   print,'Invalid selects ',selects
   !tcvcs_error = 'ALIM_MODE : ERROR ON selects'
   print,'_-_- '+stime()+' ALIM_MODE: aborted'
   return
endif

if (strtrim(!tcvcs_error) ne '') then return

print,'_-_- '+stime()+' ALIM_MODE: opening TCV_SHOT model'
; write out to the PCS tree and print action
mds$open,'tcv_shot',-1

print,'_-_- '+stime()+' ALIM_MODE: writing modes'
mds$put,'\PCS::ALIM_MODES',  '$',modes
print,'_-_- '+stime()+' ALIM_MODE: writing levels'
mds$put,'\PCS::ALIM_LEVELS', '$',levels
print,'_-_- '+stime()+' ALIM_MODE: writing selects'
mds$put,'\PCS::ALIM_SELECTS','$',selects

format='(20a4)'
print,'Modes / Levels / Selects = '
print,modes,  format=format
print,levels, format=format
print,selects,format=format

if (n_params() eq 4) then begin
  mds$put,'\PCS::LOAD_SIGN_BITS','$',signbit
  print,'Initial signs for currents are: '
  print,signbit(0:7)
  print,signbit(8:15)
  print,signbit(16:17)
endif

print,'_-_- '+stime()+' ALIM_MODE: finished'

end
