
pro add_z,mat_inputs,mat_outputs,mat

; $$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$ TCVCS RECIPE ROUTINE

; This routine is part of the TCVCS Recipe concept.
; AS such, it must be guaranteed to have been tested.
; ALL modifications to this routine must be checked off
; on a new listing of the module.

;+ TCVCS FILE : ADD_Z.pro

; PURPOSE :
; Looks for an A-matrix observer called ZIP, and creates it

; ARGUMENTS :
; mat_inputs	A-Matrix input names
; mat_outputs	A-Matrix output names
; mat		A_Matrix

; RESTRICTIONS :

; UPDATED/REASONS :
; 	Jo Lister, Dec 1993 	Original
;-
; Controlled by :       Jo
;                       Michael
; $$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$


mat_inputs = strupcase(mat_inputs)
mat_outputs = strupcase(mat_outputs)
nmat = n_elements(mat(0,0,*))

; check if there are any ZIP outputs
count = fix(0)
out_index = where(strpos(mat_outputs,'ZIP',0) ne -1,count)
if (count eq 0) then return
print,'ADD ZIP to ',out_index

; we use the complete flux loops for the compensation
loops=[7,8,9,12,13,14,15,25,26,27,28,31,32,33]
loops='CTLINT:RVLOOP_'+iii(loops)
coils = 'CTLINT:BPOL_AVG_'+iii(indgen(38)+1)

; ##### INCREASE THE DIMENSIONS of MAT if necessary to add some inputs
prein=n_elements(mat_inputs)
count = fix(0)
extra = 0
for i=0,n_elements(coils)-1 do begin
  in_index = where(mat_inputs eq coils(i) , count)
  if(count eq 0) then begin
    extra = extra + 1
    mat_inputs = [mat_inputs,coils(i)]
  endif
endfor

for i=0,n_elements(loops)-1 do begin
  in_index = where(mat_inputs eq loops(i) , count)
  if(count eq 0) then begin
    extra = extra + 1
    mat_inputs = [mat_inputs,loops(i)]
  endif
endfor

if(extra gt 0) then begin mat = [[mat], $
	[fltarr(n_elements(mat_outputs),extra,nmat)]] & $
	print,'PRE/POST inputs are :',prein,n_elements(mat_inputs)&end

; ########## FIRST DO THE BPOL contributions to the ZIP

lengths = mds$value('\magnetics::iplasma:trapeze:coeff')
zb = mds$value('static("\\mag_probe:val:z")')
contrib = lengths * zb / (!pi*4.e-7)

; first we zero the outputs, just in case
mat(out_index,*,*) = 0.0
; now we fill the relevant outputs
in_index = intarr(n_elements(coils))
for i=0,n_elements(coils)-1 do in_index(i) = where(mat_inputs eq coils(i) )
for i=0,n_elements(out_index)-1 do  $
	for j=0,nmat-1 do mat(out_index(i),in_index,j) = contrib

; ##### Now do the LOOPS contributions

; the flux loop sensitivity vector is obtained from the procedure Z_CALIB
; third version without the partial flux-loops 10,11,29,30
;b=[ 1561,       45019,      -38624 ,     110752,      106552   ,   -46160 ,       7695, $
;      -12977 ,      73231  ,    -57375 ,    -114451 ,    -110610,       30673,       -2508]
; New version, 16-7-98
b=[      17029  ,    14568   ,   12292   ,      42     ,  9683 ,      9716, $
        8657    ,   -7884  ,     -8644  ,    -8653   ,     300 ,    -12971, $
      -15815   ,   -19185 ]

in_index = intarr(n_elements(loops))
for i=0,n_elements(loops)-1  do  in_index(i) = where(mat_inputs eq loops(i))
for i=0,n_elements(out_index)-1 do $
	for j=0,nmat-1 do mat(out_index(i),in_index,j) = b

end
