pro add_fringes,mat_inputs,mat_outputs,mat

; $$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$ TCVCS RECIPE ROUTINE

; This routine is part of the TCVCS Recipe concept.
; AS such, it must be guaranteed to have been tested.
; ALL modifications to this routine must be checked off
; on a new listing of the module.

;+ TCVCS FILE : ADD_FRINGES.pro

; PURPOSE :
; Looks for A-matrix observers called *FRINGES or *DENSITY, and creates them

; ARGUMENTS :
; mat_inputs	A-Matrix input names
; mat_outputs	A-Matrix output names
; mat		A_Matrix

; RESTRICTIONS :

; UPDATED/REASONS :
; 	Jo Lister, April 1994 	Original
;	Jo Lister  June 1994	Add line-density
;-
; Controlled by :       Jo
;                       Michael
; $$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$

mat_inputs = strupcase(mat_inputs)
mat_outputs = strupcase(mat_outputs)
nmat = n_elements(mat(0,0,*))

; check if there are any FRINGES or DENSITY outputs
fcount = fix(0)
fout_index = where(strpos(mat_outputs,'FRINGES',0) ne -1,fcount)
; check if there are any DENSITY outputs
dcount = fix(0)
dout_index = where(strpos(mat_outputs,'DENSITY',0) ne -1,dcount)
if (fcount+dcount eq 0) then return
out_index = [fout_index,dout_index]
out_index=out_index(where(out_index ne -1))
print,'ADD FRINGES/DENSITY to ',out_index

; ##### INCREASE THE DIMENSIONS of MAT if necessary to add some inputs
prein=n_elements(mat_inputs)
count = fix(0)
extra = 0
in_index = where(mat_inputs eq 'FIR_FRINGE' , count)
if(count eq 0) then begin
    extra = extra + 1
    mat_inputs = [mat_inputs,'FIR_FRINGE']
endif

if(extra gt 0) then begin mat = [[mat], $
	[fltarr(n_elements(mat_outputs),extra,nmat)]] & $
	print,'PRE/POST inputs are :',prein,n_elements(mat_inputs)&end

in_index =  where(mat_inputs eq 'FIR_FRINGE')
; first we zero the line
mat(out_index,*,*)=0.0

; then we add the observer
if(fout_index(0) ne -1) then mat(fout_index,in_index(0),*) = 1.0
if(dout_index(0) ne -1) then mat(dout_index,in_index(0),*) =  $
					mds$value('\diagz::fir:dens_per_fri')

end
