function G = get_vacuum_static(sela,selu,nu)
% Get static tree matrices for vacuum model

dima = fdima(sela);
dimu = cellstr(num2str((1:nu)',[selu,'_%03d']));

% Static tree matrices
[Maa,s]   = mdsvalue('STATIC("MUT_A_A"   )[ $1,$2]',dima,dima);
assert(logical(rem(s,2)),'problem retrieving from static tree, is shot open?')
[Ra,s]    = mdsvalue('STATIC("RES_A")[ $1]', dima);
assert(logical(rem(s,2)),'problem retrieving from static tree, is shot open?')

Mxa   = mdsvalue('STATIC("MUT_X_A"   )[*,$1]',dima);
rx    = mdsvalue('static("r_x:AXIS")');
zx    = mdsvalue('static("z_x:AXIS")');
Brxa  = mdsvalue('static("Br_x_a")[*,$1]',dima);
Bzxa  = mdsvalue('static("Bz_x_a")[*,$1]',dima);

assert(isnumeric(Maa) && isnumeric(Ra),...
  'non-numeric Maa and/or Ra, something is wrong');
na = numel(Ra);

if isempty(selu)
  Muu = []; Ru = []; Mxu=[]; Mua = zeros(0,na); Mau = zeros(na,[]); 
  Brxu = []; Bzxu = [];
  Tvu = []; nu = 0; nv=0;
else
  [nuu,s] = mdsvalue(sprintf('static("n_%s")',selu));
  assert(logical(rem(s,2)),'problem loading from mds');
  if isempty(nu),nu=nuu; end
  
  if isempty(strfind(selu,'e')) %#ok<*STREMP>
    % if not eigenmode, use nu from tree
    assert(nu==nuu,'invalid nu for this vessel description');
  else
    % take nu from user input
    assert(nu<=nuu,'nu must be smaller than %d for this input',nuu);
  end
  ou = 1:nu; % select N eigenvalues
  Muu = mdsvalue('static("mut_"//$1//"_"//$1//"")',selu,selu); Muu  = Muu(ou,ou);
  Ru  = mdsvalue('static("res_"//$1//"")',selu);               Ru   = Ru(ou);
  Mua = mdsvalue('static("mut_"//$1//"_a")[*,$2]',selu,dima);  Mua  = Mua(ou,:);
  Mxu = mdsvalue('static("mut_x_"//$1//"")',selu);             Mxu  = Mxu(:,ou);
  
  Brxu  = mdsvalue('static("Br_x_"//$1//"")',selu);            Brxu = Brxu(:,ou);
  Bzxu  = mdsvalue('static("Bz_x_"//$1//"")',selu);            Bzxu = Bzxu(:,ou);


  Mau = Mua';
  if any(strcmp(selu,{'v','vx'}))
    Tvu = eye(nu);
  elseif ~isempty(strfind(selu,'x'))
    Tvu = mdsvalue(sprintf('static("T_vx_%s")',selu)); Tvu=Tvu(:,1:nu);
  else
    Tvu = mdsvalue(sprintf('static("T_v_%s")',selu)); Tvu=Tvu(:,1:nu);
  end
  nv = size(Tvu,1);
end

%% limits
Ialim = mdsvalue('STATIC("INOM_A")[$1]',dima); % Current limits
Valim = mdsvalue('STATIC("UNOM_A")[$1]',dima); % Current limits

%%

G.Maa = Maa;
G.Mxa = Mxa;
G.Ra  = Ra;
G.na  = na;
G.Muu = Muu;
G.Mxu = Mxu;
G.rx  = rx;
G.zx  = zx;
G.Mau = Mau;
G.Mua = Mua;
G.Brxa = Brxa;
G.Bzxa = Bzxa;
G.Brxu = Brxu;
G.Bzxu = Bzxu;
G.rx = rx;
G.zx = zx;
G.Ru  = Ru;
G.nu  = nu;
G.Tvu = Tvu;
G.nv = nv;
G.dima = dima;
G.dimu = dimu;
G.Ialim = Ialim;
G.Valim = Valim;

end

function dima = fdima(sela)
% default dima (coil selection)
dima=[];
for k = 1:length(sela)
  switch sela{k}
    case 'E',  l = 1:8;
    case 'F',  l = 1:8;
    case 'G',  l = 1;
    case 'OH', l = 1:2;
    case 'TOR', l = 1;
    otherwise, error('unknown coil');
  end
  dima = [dima; cellstr(num2str(l(:),[sela{k} '_%03d']))]; %#ok<AGROW>
end
end
