function xpointmath(H)
% Function for checking some X point mathematics
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

 if nargin == 0, H = [1 .5 ; .5 -2]; end
 
 syms Hrr Hzz Hrz
 pretty(eig([Hrr Hrz ; Hrz Hzz]))
 
 assert(H(1,2)==H(2,1),'not symetric')
 
 l0 = flipud(eig(H));
 li = sqrt((H(1,1)-H(2,2))^2+4*H(1,2)^2);
 l1 = (H(1,1)+H(2,2)+li*[1;-1])/2;
 l = [l0 l1]
 
 [v0,~] = eig(H); v0 = v0(:,2);
 
 t0 = atan2(v0(2),v0(1));
 if t0 >  pi/2; t0 = t0 - pi; end
 if t0 < -pi/2; t0 = t0 + pi; end
 t1 = atan2(2*H(1,2),H(1,1)-H(2,2))/2;
 t = [t0 t1]
 
 v1 = [cos(t1) ; sin(t1)];
 v2 = [sign(H(1,2))*sqrt(l(1)-H(2,2)); sqrt(l(1)-H(1,1)) ;];
 
 [v0 v1 v2/norm(v2)]
 
 
end
