% Axuiliary script used for calculating flops
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

r = 75;
e = 56;
i = 2;
g = 3;
z = 1;
s = 12;

for s = 1:20

E{1} = ' Jg = ( iAgg * ( Wgr * Yr + Wgi * Yi ) ) - ( iAgg * Wgr * Wrz ) * dz - ( iAgg * Wgr * [ Wre ] ) * Je ';
flop(1) = g*(g-1)*(r+i) + ... % Agg
          2*g*g*r + 2*g*r + g + 2*g*i + ... % iAgg * ( Wgr * Yr + Wgi * Yi )
          2*g*g*r*z + 2*r*r*z + ... % ( iAgg * Wgr * Wrz )
          2*g*g*r + 2*r*r*e + ... % ( iAgg * Wgr * [ Wre ] )
          s * ( g + 2*g*z + g + 2*g*e ); % ( ) - ( ) * dz - ( ) * Je
E{2} = ' Je = ( [ iAee * Wer ] * Yr  + [ iAee * Wee ] * Ye ) - ( [ iAee * Wer ] * Wrz ) * dz - ( [ iAee * Wer ] * Wrg ) * Jg ';
flop(2) = 2*e*r + e + ... % ( [ iAee * Wer ] * Yr +
          2*e*e + ... % [ iAee * Wee ] * Ye )
          2*e*r*z + ... % ( [ iAee * Wer ] * Wrz )
          2*e*r*g + ... % ( [ iAee * Wer ] * Wrg )
          s * ( e + 2*z*e + e + 2*e*g ); % ( ) - ( ) * dz - ( ) * Jg
E{3} = ' dz = ( Wzr / ( Wzr * Wrz ) ) * ( Yr - Wrg * Jg - Wre * Je ) ';
flop(3) = 2*z*r*z + z*r + ... % ( Wzr / ( Wzr * Wrz ) )
          s * z * (2*z*r + r + 2*r*g + r + 2*r*e ); % ( ) * ( Yr - Wrg * Jg - Wre * Je )
x(s) = sum(flop);

end