classdef meqsize_test < meq_test
  % Test meq output sizes
  %
  % [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.
  
  properties
    verbose = 0;
    tokamak = 'ana'
    shot = 1;
  end
  
  methods(Test,TestTags={'Integration'})
    function test_all(testCase)
      t = 0;
      tok = testCase.tokamak;
      
      [Lfbt,LXfbt] = fbt(tok,testCase.shot,[],...
        'debug',testCase.verbose);
      
      %% Solve FBT
      LYfbt = fbtt(Lfbt,LXfbt);
      testCase.assertNotEmpty(LYfbt,'FBT returned empty structure');
      
      testCase.test_sizes(Lfbt,LYfbt);
      
      %% solve FGS
      [Lfgs] = fgs(tok,testCase.shot,t(1),'debug',testCase.verbose,...
        'mkryl',50,'algo','jfnk','tolF',1e-5);
      LXfgs = meqxconvert(Lfbt,LYfbt,Lfgs);
      LYfgs = fgst(Lfgs,LXfgs);
      

      testCase.test_sizes(Lfgs,LXfgs);
      testCase.test_sizes(Lfgs,LYfgs);
    end
  end
  
  methods
    function test_sizes(testCase,L,myvar)
      % check variable sizes
      for ifield=fieldnames(myvar)
        myfield = ifield{:};
        testCase.verifyEqual(size(myvar.(myfield)),meqsize(L,myfield),...
          sprintf('%s does not have expected size',myfield));
      end
    end
  end
end

