classdef meqps_test < meq_test
  % Tests for meq power supply module  
  %
  % [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.
  
  properties
    verbose = 0;
  end
  
  properties(TestParameter)
    Vadelay = {[1e-3,1e-4],[1e-3,0],[0 0]}; % Delay in voltage output
    dt = {1e-5;1e-4}; % time sampling
  end
  
  methods(Test,TestTags={'Unit'})
    
    function test_delay_and_saturation(testCase,dt,Vadelay)
      % Checks whether delays and saturation work as expected
      
      G.na = 2;
      G.Vadelay = Vadelay;
      G.Ialim =  [100;100];
      G.Valim =  [5;10];
      
      % init
      [pstate] = meqps(G,[],dt,0);
      
      N = 1e-3/dt;
      tgrid = (0:N-1)*dt;
      
      Vreq = [1;-1]*round(tgrid/dt);
      V = zeros(size(Vreq));
      I = zeros(size(Vreq));
      
      for it = 1:N
        [pstate,V(:,it)] = meqps(G,pstate,dt,it,Vreq(:,it));
        
      end
      
      if testCase.verbose
        subplot(211)
        plot(tgrid,Vreq,'bx',tgrid,V,'rx--')
      end
      
      itdelay = (G.Vadelay/dt);
      for ia=1:G.na
        Vreqsat = min(max(Vreq,-G.Valim(ia)),G.Valim(ia));
        testCase.assertEqual(Vreqsat(ia,1:end-itdelay(ia)),V(ia,itdelay(ia)+1:end))
        
        if testCase.verbose
          subplot(212)
          plot(Vreqsat(ia,1:end-itdelay(ia)),'b'); hold on;
          plot(      V(ia,itdelay(ia)+1:end),'r--');
        end
      end
      
    end
  end
end
