classdef meq_check_headers < check_headers & meq_test
  % Checks whether desired copyright headers are in place
  % Can be used to fix them automatically by setting `dofix=true`
  % mytest = check_headers
  % mytest.dofix = true; % changes property
  % mytest.run; % runs
  %
  % [+MEQ MatlabEQuilibrium Toolbox+] Sw+ss Plasma Center EPF+Lausanne 2022. All rights reserved.

  
  properties
    dofix = false; % if true, modify files to fix header
    IgnoredPaths = {'csfc','obj','slprj','.git','tutorials','genlib'};
    old_headers = {'[+MEQ MatlabEQuilibrium Toolbox+]',...
      'FreeBoundaryTokamakEquilibrium',...
      'LIUQEibrium reconstruction'};
    desired_header = '[+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.';
    test_folder = fileparts(fileparts(mfilename('fullpath')));
  end

  methods(Test,TestTags={'Unit'})
    function check_and_fix_files(testCase)
      check_and_fix_files@check_headers(testCase);
    end
  end
end