classdef lyall_tests < meq_test
% Tests of returining all LY time slices also for failed slices.
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

  properties
    verbose = 0;
  end
  
  methods(Test,TestTags={'Unit'})
    function test_lyall(testCase)
      % Tests to check output of failing slices
      
      L = liu('ana',82,[],'selu','n','idoublet',false,'LYall',true);
      
      [~,~,LYb] = fbt('ana',82,[],'iterq',0,'bfct',L.P.bfct,'bfp',L.P.bfp); % input time is arbitrary for fbtana (one equilibrium)
      
      % keep only measurements
      fields = {'t','Bm','Ff','Ip','Ia','Iu','Ft','rBt'};
      for ii=fields
        LX.(ii{:}) = LYb.(ii{:});
      end
      LX.shot = LYb.shot;
      
      LY = liut(L,LX);
      
      testCase.verifyTrue(~isempty(LY),'LY is empty with LYall=true');
      testCase.verifyTrue(~LY.isconverged,'liu has converged on a doublet case with idoublet=false');
    end
  end
end
