classdef jBwregtcv_test < meq_test
  % Test for current profile regularization in J
  %
  % [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

  properties (TestParameter)
    shot = {61400};
    time = {1};
  end
  
  methods(Test, TestTags = {'TCV'})
    function increasing_jBwreg(testCase,shot,time)
      jB_wreg = [1e0,1e2,1e4];

      wreg_ = NaN;
      jB_ = Inf;
      
      for ii = 1:numel(jB_wreg)
        [L,~,LY] = liuqe(shot,time,'bfct',@bfef,'bfp',[2 4],'wreg',5e-8*[1;1;jB_wreg(ii)*[1;1]]);
        testCase.assertTrue(~isempty(LY),sprintf('LIUQE did not converge for wreg_jB=%e',jB_wreg(ii)));
        
        [ fPg,  fTg] = L.bfct(0,L.bfp);
        [ gQg,    ~] = L.bfct(2,L.bfp,1,LY.FA,LY.FB);
        [aPpg,aTTpg] = L.bfct(3,L.bfp,LY.ag,LY.FA,LY.FB,fPg,fTg,L.idsx);
        jB = gQg .* aPpg' * fPg * LY.rA + gQg .* aTTpg.' * fTg /LY.rA /mu0; % Current density at psiN=1 for r=rA
        % Check that it did decrease after we increased wreg
        testCase.verifyLessThan(abs(jB),abs(jB_),sprintf('Edge current did not decrease between wreg_jB=%e (%e) and %e (%e)\n\t ',wreg_,jB_,jB_wreg(ii),jB));
        
        wreg_ = jB_wreg(ii);
        jB_ = jB;
      end
    end
  end
end
  
