%% Script for exercising LIUQE FE fit
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

clear all;

shot = 55331; time = 0:1e-4:0.05;
shot = 66938; time = 0.38:1e-4:0.45;

% Standard FE fit
[L,LX] = liuqe(shot,time,'iterh',0);

% IPMH FE fit
[Lh] = liuqe(shot,[],'iterh',30,'tolh',1e-3,...
  'Ipmin',10e3,'idoublet',true,...
  'rip',NaN,'rop',NaN,'zup',NaN,'zlp',NaN,'nelem',12);

%%
LY  = liht(L ,LX); % standard observer
LYh = liht(Lh,LX); % ipmh observer

%%
clf;
meqplotD(L,LY,LYh);

%%

