%% Comparison between RZIP and FGE growth rete
% Compute the growth rate for linearized FGE and RZIP for several shot of different nature
% Warning computing the linearization if pretty slow at the moment ( need to solve equivalent of FGS ~ 300 times)
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

close all
clear all
clc

%% 
addpath(genpath('/home/carpanes/meq_GIT'))
addpath(genpath('/home/carpanes/rzip'))

%% Compare the eigenvalue between RZIP and the linearized version for sevaral shots 
list_shot = [65668,65299,63783,40000];
t = 0.3; % Select timeslice during flat-top phase

%% Compute RZIP growth rates
for ii = 1:numel(list_shot)
[LFGS,~,LYFGS] = fge('TCV',list_shot(ii), t, 'insrc', 'liu');
[MFGE(ii)] = fgelin(LFGS,LYFGS);
[sys,sysinfo] = make_rzip_model('v',256,'fgs',LFGS,LYFGS,'TCV',1:19,list_shot(ii),t);
growFGE(ii) = max(real(eig(MFGE(ii).A)));
growth_rate(ii) = max(real(eig(sys.A)));
end
  
%% Plot all the growth rates
figure
hold on 
plot(1:numel(list_shot), growth_rate, '*', 'DisplayName', 'RZIP')
plot(1:numel(list_shot), growFGE, 'o',  'DisplayName', 'FGE')
xticks([1:numel(list_shot)])
xticklabels(cellstr(num2str(list_shot')))
ylabel('Growth rate [Hz]')
xlabel('shot')
legend('show')
title('Comparison of growthrate')



