function [LX] = rzpinit(L,LX)
% function [LX] = rzpinit(L,LX)
% Compute statonary-state initial condition for RZP, and LX.Va 
% (possibly time-varying, when solving CDE) to sustain the initial 
% equilibrium.
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

%% Find Ia, Iv, Va consistent with initial equilibrium.
LX = meqinit(L,LX);

%% Compute RZP output to have a consistent starting equilibrium
% Call meqreprocess for computing post-processing quantities
% necessary for rzpl, but not present after meqinit.
LX = meqreprocess(L,LX);
end
