function rzpfastAmexify(L,store_dir,out_dir)
%% rzpfastAmexify(L,store_dir,out_dir)
% mexify rzpfastA for current model settings
% run test function to initialize variables (such as L = rzp('tcv',61400,0.5,'selu','e','nu',20))
% function to mexify:
% A = rzpfastA(Ia,Iu,Iy,Ip,rIp,Mey,Mee,Re,Bzxa,Bzxu,Brxa,Brxu,drx,dzx,nry,nzy,np,lxy)
%
% Input
%   L: example structure used to identify variables dimensions
%   store_dir: directory where to store .c, .h, .sh and other non useful
%              files. Usually a temp directory of the user
%   out_dir: output directory where to place the mex (mexified) file
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

if nargin < 3 
  out_dir = fileparts(mfilename('fullpath'));
  if nargin < 2
    store_dir = sprintf('/tmp/%s',getenv('USER'));
  end
end

%% define examples
Ia   = coder.typeof(ones(L.G.na,1));
Iu   = coder.typeof(ones(L.G.nu,1));
Iy   = coder.typeof(ones(L.nzy,L.nry));
Ip   = coder.typeof(ones(L.nD,1));
rIp  = coder.typeof(ones(L.nD,1));
bp   = coder.typeof(ones(L.nD,1));
Rp   = coder.typeof(ones(L.nD,1));

Mey  = coder.typeof(L.Mey);
Mee  = coder.typeof(L.Mee);
Re   = coder.typeof(L.Re);
RBrye = coder.typeof(L.RBrye);
RBzye = coder.typeof(L.RBzye);
drx  = coder.typeof(L.drx);
dzx  = coder.typeof(L.dzx);
ny   = coder.typeof(L.ny);
np   = coder.typeof(L.np);
ne   = coder.typeof(L.ne);

icde = coder.typeof(L.icde); 

%% settings
codercfg = coder.config('mex');
example_inputs = {Ia,Iu,Iy,Ip,rIp,bp,Mey,Mee,Re,Rp,RBrye,RBzye,drx,dzx,ny,np,ne,icde};
code_folder = store_dir;
if ~exist(code_folder,'dir')
  mkdir(code_folder);
end
out_file = fullfile(out_dir,'rzpfastA_mex');
entry_point_fct = which('rzpfastA');

%% check if correct mex already exists
if exist(out_file,'file')
     disp('rzpfastA_mex already seems to exist for this model')
     fprintf('Delete %s to force generation of new mex\n',which('rzpfastA_mex.mexa64'))
     return
end

%% run codegen
fprintf('Generating mex for rzpfastA, please wait...')
codegen('-d',code_folder,'-o',out_file,'-config',codercfg,'-v',entry_point_fct,'-args',example_inputs);
fprintf('..done\n')


end