function Ls = meqrmcde(L)
% substitute any 'CDE' entries with 'Ip' (FGS can not use CDE)
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

Ls=L;
icde = find(contains(lower(cellfun(@func2str,Ls.agconc(:,1),'UniformOutput',false)),'cde'));
for ii=1:numel(icde)
  ll = meqagconfun(); % catalog
  Ls.agconc{icde(ii),1} = ll{strcmp(cellfun(@func2str,ll,'UniformOutput',false),'Ip')};
  if ~L.P.idoublet, Ls.agconc{icde(ii),3} = 'Ip';
  else,             Ls.agconc{icde(ii),3} = 'IpD';
  end
end
end