%MEQMDSOPEN(SHOT,TREE[,BRANCH])
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.
function meqmdsopen(shot,tree,branch,server)
 if ~(nargin == 4 && ~isempty(server))
   server = 'tcvdata.epfl.ch';
 end

 assert(~isempty(which('mdsopen')),'MEQ:NoMDS','mdsopen not found, are mds tools installed?')
 assert(logical(mdsconnect(server)),'Can not connect to %s mdsplus server',server)
 assert(~isempty(mdsopen(tree,shot)),'Can not open shot %s #%d',tree,shot);
 if nargin == 3 && ~isempty(branch)
  assert(isodd(mdssetdef(branch)),'Can not select branch %s',branch);
 end
end