%MEQLARG  Make a structure with arguments
% MEQLARG(P1,...) returns a structure with fields corresponding to the name
% of the passed variables P1,... and assigns P1,... to those fields. Note
% that it cannot take expressions as arguments. When called with a
% structure as first argument, it adds the fields to that structure.
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.
function S = meqlarg(varargin)
 if nargin && isstruct(varargin{1})
  S = varargin{1};
  k = 2;
 else
  k = 1;
 end
 for k = k:nargin
  S.(inputname(k)) = varargin{k};
 end