function meqinfo(L,LX)
% Display information about meq run parameters
% For now works only for FGE and FGS
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

fprintf('\n *** %s ***\n',upper(L.code));
fprintf('  Tokamak: %s, shot#%d, t=%3.3f\n',L.P.tokamak,LX.shot(1),LX.t(1))
fprintf('  Solver: %s + %s',L.P.algoNL,L.P.algoF)
if isequal(L.P.algoF,'jfnk')
  fprintf('GMRES: %s\n',L.P.algoGMRES')
  fprintf('  prec:%d, mkryl:%d, kmax:%d ',L.P.usepreconditioner,L.P.mkryl,L.P.kmax);
else
  fprintf('  prec:%d %s\n',L.P.usepreconditioner);
end
fprintf('  tolF:%3.3e\n',L.P.tolF);
fprintf('  Vessel:%s, nu:%d\n',L.P.selu,L.G.nu);
fprintf('  Doublet: %d\n',L.P.idoublet);
fprintf('  Constraints: \n')
fprintf('    Fun    iD    LXfield \n');
fprintf('   --------------------- \n');disp(L.agconc);
fprintf('\n\n');
end
