%MKMEQH  Generates include file MEQ.H
% MKMEQH(FILES) generates the include file MEQ.H for MEQLIB. Used by
% MAKEFILE.
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.
function mkmeqh(files)

fh = fopen('meq.h','w');
fprintf(fh,'/* [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved. */\n');
fprintf(fh,'/* Generated by mkmeqh.m %s */\n# include "meqh.h"\n',datestr(now));
fprintf(fh,'#ifdef __cplusplus\nextern "C" {\n#endif\n');

while true
 [file,files] = strtok(files,' ');
 if isempty(file), break, end
 [~,grep] = system(['grep -e "\<[sd]' file '[0-9]*\>" mexc/*.c csfc/*.c -l -s']);
 grep(grep==10) = ',';
 fprintf('Doing %12s in %s\n',file,grep(1:end-1))
 ff = fopen(['libmeq/' file '.c'],'r');
 t = fread(ff,Inf,'*char')';
 fclose(ff);
 t = regexp(t,'(.*?)(\<\w+\s+FCT\w*?\(.*?\))','tokens');
 for k = 1:length(t)
  tn = regexprep(t{k}{2},'\s+',' ');
  ts = strrep(strrep(tn,'FCT',['s' file]),'FLT','float ');
  td = strrep(strrep(tn,'FCT',['d' file]),'FLT','double');
  fprintf(fh,'%s;\n%s;\n',ts,td);
 end
end
fprintf(fh,'#ifdef __cplusplus\n}\n#endif\n');
fclose(fh);
