%IPMJMEX Interior point method for base function fitting
%
% This is the MATLAB equivalent implementation of libmeq/ipmj.c.
% A more detailed help is available in IPMJMEX.
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.
function [Ie,aj,st] = ipmjmexm(uAjj,Aje,Aej,Ie0,aj0,Ie_,aj_,Qcj,Xc,s,z,tol,iters)
 Ie = Ie_;
 aj1 = aj_;
 for kit = 1:iters
  aj2 = aj0+Aje*Ie;
  % Do a single IPM iteration
  [aj,s,z,st] = ipm2mexm(uAjj,aj2,Qcj,Xc,aj1,s,z,tol*1e6,1);
  Ie = Ie0 + Aej*aj;
  st = st && norm(aj-aj1,Inf) < tol;
  if st, break, end
  aj1 = aj;
 end
end