/* [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved. */
# include "meq.h"

void mexFunction(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{

 /* [Q0Q,Q1Q,Q2Q,Q3Q,Q4Q,iqQ] = fsgimex(M1q,M2q,rq,irq,rA,FA,FB,d2nFA,lX,rB,iTQ,idoq) */

# define MEXNAME fsgimex

# define Q0Q   pout[ 0]
# define Q1Q   pout[ 1]
# define Q2Q   pout[ 2]
# define Q3Q   pout[ 3]
# define Q4Q   pout[ 4]
# define iqQ   pout[ 5]

# define M1q   prhs[ 0]  /* double, def size=[noq,npq] */
# define M2q   prhs[ 1]  /* double, size=noq*npq */
# define rq    prhs[ 2]  /* double, size=noq*npq */
# define irq   prhs[ 3]  /* double, size=noq*npq */
# define rA    prhs[ 4]  /* numeric, scalar */
# define FA    prhs[ 5]  /* numeric, scalar */
# define FB    prhs[ 6]  /* numeric, scalar */
# define d2nFA prhs[ 7]  /* numeric, scalar */
# define lX    prhs[ 8]  /* logical, scalar */
# define rB    prhs[ 9]  /* numeric, scalar */
# define iTQ   prhs[10]  /* double, size=npq+1 */
# define idoq  prhs[11]  /* numeric, scalar */

 CHECK_NARGIN_EQ(12);

 int noq = mxGetM(M1q), npq = mxGetN(M1q);

 CHECK_DOUBLE(M1q);
 CHECK_DOUBLE(M2q);
 CHECK_NUMEL(M2q,noq*npq);
 CHECK_DOUBLE(rq);
 CHECK_NUMEL(rq,noq*npq);
 CHECK_DOUBLE(irq);
 CHECK_NUMEL(irq,noq*npq);
 CHECK_NUMERIC(rA);
 CHECK_SCALAR(rA);
 CHECK_NUMERIC(FA);
 CHECK_SCALAR(FA);
 CHECK_NUMERIC(FB);
 CHECK_SCALAR(FB);
 CHECK_NUMERIC(d2nFA);
 CHECK_SCALAR(d2nFA);
 CHECK_LOGICAL(lX);
 CHECK_SCALAR(lX);
 CHECK_NUMERIC(rB);
 CHECK_SCALAR(rB);
 CHECK_DOUBLE(iTQ);
 CHECK_NUMEL(iTQ,npq+1);
 CHECK_NUMERIC(idoq);
 CHECK_SCALAR(idoq);

 CHECK_NARGOUT_LE(6);

 mxArray *pout[6];

 Q0Q = mxCreateDoubleMatrix(npq+1,1,mxREAL);
 Q1Q = mxCreateDoubleMatrix(npq+1,1,mxREAL);
 Q2Q = mxCreateDoubleMatrix(npq+1,1,mxREAL);
 Q3Q = mxCreateDoubleMatrix(npq+1,1,mxREAL);
 Q4Q = mxCreateDoubleMatrix(npq+1,1,mxREAL);
 iqQ = mxCreateDoubleMatrix(npq+1,1,mxREAL);
 dfsgi(mxGetPr(Q0Q), mxGetPr(Q1Q), mxGetPr(Q2Q), mxGetPr(Q3Q),
       mxGetPr(Q4Q), mxGetPr(iqQ),
       mxGetPr(M1q), mxGetPr(M2q), mxGetPr(rq), mxGetPr(irq),
       mxGetScalar(rA), mxGetScalar(FA), mxGetScalar(FB), mxGetScalar(d2nFA),
       mxIsLogicalScalarTrue(lX), mxGetScalar(rB), mxGetPr(iTQ),
       mxGetScalar(idoq), npq, noq);

 ASSIGN_PLHS;
}
