/* [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved. */
# include "meq.h"

void mexFunction(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{

 /* function Fl = fl4pmex(Fx,kl,cl,FN,rl,zl,rA,zA) */

# define MEXNAME fl4pmex

# define FL pout[0]

# define FX prhs[0]  /* double, def size=[nz,*] */
# define KL prhs[1]  /* int32, def size=nl */
# define CL prhs[2]  /* double, size=4*nl */
# define FN prhs[3]  /* numeric, scalar */
# define RL prhs[4]  /* double, size=nl */
# define ZL prhs[5]  /* double, size=nl */
# define RA prhs[6]  /* numeric, scalar */
# define ZA prhs[7]  /* numeric, scalar */

 /* Replacement for CHECK_NARGIN_* */
 if (nrhs != 3 && nrhs != 8) mexErrMsgIdAndTxt("fl4pmex:nargin","fl4pmex should have 3 or 8 arguments");

 int nz = mxGetM(FX), nl = mxGetNumberOfElements(KL);

 CHECK_DOUBLE(FX);
 CHECK_INT32(KL);
 CHECK_DOUBLE(CL);
 CHECK_NUMEL(CL,4*nl);
 if (nrhs>3) 
 {
  CHECK_NUMERIC(FN);
  CHECK_SCALAR(FN);
  CHECK_DOUBLE(RL);
  CHECK_NUMEL(RL,nl);
  CHECK_DOUBLE(ZL);
  CHECK_NUMEL(ZL,nl);
  CHECK_NUMERIC(RA);
  CHECK_SCALAR(RA);
  CHECK_NUMERIC(ZA);
  CHECK_SCALAR(ZA);
 }

 CHECK_NARGOUT_LE(1);

 mxArray *pout[1];

 double  fn = nrhs>3 ? mxGetScalar(FN) : 0.0;
 double* rl = nrhs>3 ? mxGetPr(RL)     : NULL;
 double* zl = nrhs>3 ? mxGetPr(ZL)     : NULL;
 double  ra = nrhs>3 ? mxGetScalar(RA) : 0.0;
 double  za = nrhs>3 ? mxGetScalar(ZA) : 0.0;
 FL = mxCreateDoubleMatrix(nl, 1, mxREAL);
 dfl4p(mxGetPr(FL), mxGetPr(FX), (int *)mxGetData(KL), mxGetPr(CL), fn, rl, zl, ra, za, nl, nz);

 ASSIGN_PLHS;
}
