/* [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved. */
# include "meq.h"

void mexFunction(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{

 /* [x1 y1 x2 y2] = bboxmex(lxy,x,y) */

# define MEXNAME bboxmex

# define B pout[0]

# define L prhs[0]  /* logical, def size=[nx,ny] */
# define X prhs[1]  /* double, size=nx */
# define Y prhs[2]  /* double, size=ny */

 CHECK_NARGIN_EQ(3);
 
 int nx = mxGetM(L), ny = mxGetN(L);

 CHECK_LOGICAL(L);
 CHECK_DOUBLE(X);
 CHECK_NUMEL(X,nx);
 CHECK_DOUBLE(Y);
 CHECK_NUMEL(Y,ny);

 CHECK_NARGOUT_LE(1);

 mxArray *pout[1];

 double *bp = mxGetPr(B = mxCreateDoubleMatrix(1,4,mxREAL));
 dbbox(bp, bp+1, bp+2, bp+3, (bool *)mxGetLogicals(L), mxGetPr(X), mxGetPr(Y), nx, ny);

 ASSIGN_PLHS;
}
