%MEQP  MEQ default algorithm configuration parameters
% P = MEQP defines default algorithm configuration parameters common to
% MEQ.
%
%%
% .tokamak      Full name of tokamak
% .tok          Short name of tokamak
% .shot         #shotnum
% .debug        debug flag
% .dasm         Minimal distance (grid points) between X and axis points [asxy]
% .lasy         Search axes and X-points also outside the limiter contour
% .xdoma        Angle of X-point polygon edges with perpendicular (>0 values to get a smaller polygon) [pdom]
% .isaddl       If ~isaddl, ignore X-points when searching LCFS
% .ilim         If 0, ignore limiter when searching LCFS. If 1, use limiter points, if 2, use quadratic interpolation, if 3: cubic splines (requires icsint) 
% .idoublet     If idoublet, allow doublet equilibria
% .ihole        If ihole (default), allow axes with current densities opposite to Ip when multiple axes are found
% .r0           default major radius used for outputs/normalizations
% .b0           default toroidal field used for outputs/normalizations
% .pq           If not empty provides user-defined radial grid (excl LCFS and axis)
% .pqu          maximum rho-psi for radial grid                   [active only if pq is empty]
% .pql          minimum rho-psi for radial grid                   [active only if pq is empty]
% .npq          number of radial grid points (excl LCFS and axis) [active only if pq is empty]
% .noq          size of theta-grid mesh for contours
% .raS          r/a values of flux surfaces for which to return r,z, coordinates
% .ri       [m] Inner boundary of computational grid                       [active only if selx is empty for TCV]
% .ro       [m] Outer boundary of computational grid                       [active only if selx is empty for TCV]
% .zl       [m] Lower boundary of computational grid                       [active only if selx is empty for TCV]
% .zu       [m] Upper boundary of computational grid                       [active only if selx is empty for TCV]
% .nr           Set radial grid points, true grid will be of size nr+1     [active only if selx is empty for TCV]
% .nz           Set vertical grid points, true grid will be of size 2*nz+1 [active only if selx is empty for TCV]
% .selu         Generalized vessel description selector string e.g. 's','e','v';
% .nu           Number of vessel variables (eigenmodes, segments)
%
% .nFW          Number of fluxes to track for wall gaps. >1 gives secondary separatrices
% .rn       [m] Radial coordinate for points for flux, field interpolations
% .zn       [m] Z coordinate for points for flux, field interpolations
% .bfct         Basis function handle
% .bfp          Basis function parameters
%
% .infct        Interpolation function handle
% .inp          Interpolation function parameters
%
% .interpmethod Interpolation method for data (default: nearest)
% .iterq        Iterations of contour algorithm, enables contour-dependent calculations
% .iqR          Value of 1/q for which to return r/a location (only if iterq>0)
% .naR          Number of ocurrences of each 1/q surfaces to track (size of raR will be [nR,naR])
% .ifield       Calculate Br,Bz fields as additional outputs
% .ivacuum      Calculate vacuum fluxes and fields Br0x, Bz0x, F0x (excluding plasma contribution)
% .izgrid       Additional 'z' grid for post-processing flux, field calculations
%
% .icsint       If icsint, use cubic spline interpolation for domain id. and contouring (default: false)
% .tolcs        Tolerance on position of axes, saddle points, limiter points and flux-surface contours [active only if icsint is true]
% .itercs       Maximum number of Newton-Raphson iterations                                            [active only if icsint is true]
%
% .mdsserver    MDS server hostname for parameters/measurements loading
%
% .gsxe         Switch for treatment of external currents inside computational grid
% .gfile        If non-empty, attempt to load geometry data from this file (see meqgload/meqgsave)
% .LYall        If true, LY contains all time slices, converged or not
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.


function D = meqp
 D.tokamak      = '';
 D.tok          = '';
 D.shot         = [];

 D.debug        = 0 ;
 D.dasm         = 2 ;
 D.idoublet     = false;
 D.lasy         = false;
 D.isaddl       = 1; 
 D.ilim         = 1;
 D.ihole        = true;
 D.xdoma        = 0;

 D.r0           = 1;
 D.b0           = 1;

 D.pq           = [];
 D.pqu          = sqrt(0.95);
 D.pql          = 0.2;
 D.raS          = [];
 D.npq          = 18;
 D.noq          = 32;
 D.ndom         = NaN;
 
 D.zl           = NaN;
 D.zu           = NaN;
 D.ri           = NaN;
 D.ro           = NaN;
 D.nr           = NaN;
 D.nz           = 32;

 D.selu         = 'v';
 D.nu           = [];
 
 D.bfct         = @bfabmex;
 D.bfp          = [1 2]; 
 
 D.nFW          = 1;
 D.infct        = [];
 D.inp          = [];
 D.rn           = [];
 D.zn           = [];
 D.iterq        = 0;
 D.iqR          = [];
 D.naR          = 1;
 D.interpmethod = 'nearest';
 D.izgrid       = false;
 D.ifield       = false;
 D.ivacuum      = false;
 
 D.gsxe         = 2; % Treat external currents inside the grid exactly
 
 D.icsint       = false;
 D.tolcs        = 1e-4;
 D.itercs       = 20;

 D.gfile        = '';
 D.LYall        = false;
 
 D.signeodflt = 1e7; % Default scaling value for signeo signeo = (1-0.9*L2.pQ')*P.signeodflt
end
