%MEQFBP  Plasma contribution to boundary condition for Poisson solver
% FB = MEQFBP(IY,L) returns the contribution from the plasma current
% distribution IY to the boundary condition for the Poisson solver. L
% contains ancillary data obtained with LIUC. See also GSZRMEX,MEQMESH.
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.
function Fb = meqfbp(Iy,L)
 % Normal flux derivative on boundary approximation: dF(x)/dx = (4F(x+dx)-F(x+2dx)-3(F(x)=0))/(2dx)
 Fb = L.Tbc*nfdbmex(gszrmex(zeros(2*(L.nzx+L.nrx-2),1),Iy,L.cx,L.cq,L.cr,L.cs,L.ci,L.co,0));
end