%MEQ2PSI  Convert MEQ LY structure to PSITBXPSI object
% PSI = MEQ2PSI(L,LY) converts the L,LY structures to a PSITBXPSI object.
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.
function psi = meq2psi(L,LY)
 if mean(LY.Ip) > 0, form='+0';
 else,               form='-0';
 end
 % Temporary fix for doublets, only treat the upper half
 if L.P.idoublet
  mask   = ((L.nzx+1)/2):L.nzx;
  L.G.zx = L.G.zx(mask);
  LY.Fx  = LY.Fx(mask,:,:);
  LY.FB  = LY.FB(LY.zB > 0);
 end
 %
 psi = psitbxpsi(...
  permute(LY.Fx-reshape(LY.FB,1,1,[]),[2 1 3]),...
  psitbxgrid('Cylindrical','Grid',{L.G.rx;L.G.zx;NaN}),...
  LY.t,form,L.P.tolcs,L.P.itercs,[L.G.rl(:) L.G.zl(:)]');
end
