/* [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved. */
# include "meqh.h"
# ifdef SINGLE
# define FCT  cblas_sspmv
# define SPMV sspmv
# else
# define FCT  cblas_dspmv
# define SPMV dspmv
# endif
void FCT(const CBLAS_LAYOUT Layout, const CBLAS_UPLO uplo, 
	const int n, const FLT alpha, const FLT *ap,
	const FLT *x, const int incx, const FLT beta, FLT *y, const int incy)
{
 ptrdiff_t n_, incx_, incy_;
 char * up = uplo == CblasUpper ? "U" : "L";
 n_ = n; incx_ = incx; incy_ = incy;
 SPMV(up, &n_, &alpha, ap, x, &incx_, &beta, y, &incy_);
}
