%LOCSMEX  Location of q surfaces
% [AS] = LOCSMEX(AQ,QQ,QS,NF) returns the location of the flux surfaces where
% QR=QQ(AQ==AR)
%
% AQ: x data (may be a matrix [nQ x m]
% QQ: y data
% QS: Requested y values
% NF: (optional) AR = NF signals the q value was not found
%
% AS: interpolated x data
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

function aR = locSmex(aQ,qQ,qR,varargin)
 warning('MEQ:MEX "%s" not compiled or not in the Matlab path',mfilename)
 
 aR = locSmexm(aQ,qQ,qR,varargin{:});
 
end
