%LIUXRFX  RFX LIUQE diagnostic measurements
% LX = LIUXRFX(EQUIL,T,L) returns a structure with diagnostic measurements
% at time T for EQUIL. See also LIUX.
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.
function X = liuxrfx(t,L)
 
 A = load(['LIUXRFX_' int2str(L.P.shot)]); A = A.X;
 nt = numel(t);
 
 X.shot = L.P.shot;
 X.t    = t;
 % X.Ff   =  resamp(A.Ff,A.tt,t)';
 % X.Uf   = -resamp(A.Uf,A.tt,t)';
 % X.Bm   =  resamp(A.Bm,A.tt,t)';
 % X.Ia   =  resamp(A.Ia,A.tt,t)';
 % X.Ft   =  zeros(1,nt);
 % X.RBt  =  zeros(1,nt);
 % X.Ip   =  resamp(A.It,A.tt,t)';
 
 X.Ff   =  interp1(A.tt,A.Ff,t)';
 X.Uf   = -interp1(A.tt,A.Uf,t)';
 X.Bm   =  interp1(A.tt,A.Bm,t)';
 X.Ia   =  interp1(A.tt,A.Ia,t)';
 X.Ft   =  zeros(1,nt);
 X.rBt  =  zeros(1,nt);
 X.Ip   =  interp1(A.tt,A.It,t)';
 
end
