% LIUPRFX  RFX LIUQE configuration parameters
% P = LIUPRFX(SHOT,'PAR',VAL,...) returns a structure P with configuration
% parameters for SHOT, optionally replacing or adding parameters with
% specified values. See also LIUP.
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.
function P = liuprfx(~,varargin)
 P.Bmerr        = 0.00999999977648258;
 P.Iaerr        = 200.000002980232;
 P.Iuerr        = 200.000002980232;
 P.chimax       = 2;
 P.debug        = 0;
 P.elomin       = Inf;
 P.Fferr        = 0.00753982272673785;
 P.idens        = 0;
 P.idml         = 0;
 P.ifara        = 0;
 P.iinv         = 0;
 P.ipolarimetry = 0;
 P.ipres        = 0;
 P.isaddl       = 1;
 P.itera        = 100;
 P.iters        = 48;
 P.itert        = 0;
 P.nelem        = 4;
 P.nr           = 32;
 P.nz           = 16;
 P.Iperr        = 24000;
 P.Ipmin        = 15000;
 P.psichco      = 4.99999987368938e-05;
 P.ri           = 1.5237;
 P.rip          = 1.5380;
 P.ro           = 2.4663;
 P.rop          = 2.4520;
 P.shot         = 36334;
 P.stab         = -1.25663708016127;
 P.stabint      = 0.100000001490116;
 P.stabz        = 1;
 P.Fterr        = 0.000127;
 P.Ipmeas       = 0;
 P.wIp          = 1;
 P.wIa          = [1;1;1;1;1;1;1;1;1;1;1;1;1;1;1;1;1;1;1;1;1;1;1;1;1;1;1;1;1;1;1;1;1;1;1;1;1;1;1;1;1;1;1;1;1;1;1;1;1;1;1;1;1;1;1;1;1;1;1;1];
 P.wBm          = [1;1;1;1;1;1;1;1;1;1;1;1;1;1;1;1;1;1;1;1;1;1;1;1;1;1;1;1;1;1;1;1;1;1;1;1;1;1;1;1];
 P.wFf          = [1;1;1;1;1;1;1;1;1;0;0;0;1;1;1;1;1;1;1;1;1;1;1;1;1;1;1;1;1;1;1;1;1;1;1;1;1;1;1;1];
 P.z0           = NaN;
 P.zlp          = -0.4570;
 P.zu           = 0.4713;
 P.zup          = 0.4570;
 P.bfct         = @bfabmex;
 P.bfp          = [1 2];
 P.pq           = (1:40)/40;
 
 % overwrites
 for k = 1:2:length(varargin)
  P.(varargin{k}) = varargin{k+1};
 end
 
end
