%LIUG  LIUQE geometry and electromagnetic parameters
% G = LIUG(G,P) defines missing fields in the structure G using parameters
% in structure P. See also MEQG.
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.
function G = liug(G,P,xargs)

if nargin<3, xargs={}; end % default
xargs = [xargs,{'Brxa','Brxu','Mby','dzMfx','dzBmx'}];

if P.gsxe == 2
  xargs = [xargs,{'Brboa','Brbou'}];
end
G = meqg(G,P,xargs{:});

% Other liuqe-specific defaults
if ~isfield(G,'Mtx')
  G.Mtx = zeros(numel(G.zx),numel(G.rx));
end
if ~isfield(G,'rW')
  G.dimW = {};
  [G.aW,G.rW,G.zW,G.oW] = deal([]);
end
if ~isfield(G,'Ipm')
  G.Ipm = zeros(0,G.nm);
end
if ~isfield(G,'Bms')
  G.Bms = zeros(G.nm,0);
end

end
